<?php
$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}



Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Unconverted Quotation Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        
        

        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        
        <div class="clear"></div>


        <div style="float: left;">
            <?php
            echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
            echo CHtml::submitButton('Go', array('name' => 'go_btn'));
            ?>
        </div>
        <?php $this->endWidget(); ?>
        <div style="float: right;">
            <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>

        </div>

        <div class="clear"></div>
    </div>
</div>
<div class="clear"></div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'unconverted-quote-grid',
    'dataProvider' => $model->searchUnconvertedQuotes(),
    'filter' => $model,
    'columns' => array(
        //'id',
        //'ws_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'ws_date',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->quotecreated))',
            'htmlOptions'=>array('style'=>'width:80px;text-align:center;')
        ),
        array(
            'name' => 'quoteno',   
            'value' => '$data->getQuoteHtml()',
            'type' => 'html',
            'htmlOptions'=>array('style'=>'width:120px;text-align:center;'),
        ),
        
        'quotename',
        
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            //'filter' => CHtml::listData(Customer::model()->findAll(array('order' => 'cusnam')), 'cuscus_fref', 'cusnam'),
            'filter' =>false,
            'type' => 'raw',
        ),
        //'systemfreight',
       
        array(
            'header'=>'Sales Person',
            'value'=>'$data->salesPersonRel->name'
        ),        
         array(
            'header' => 'Price',
            'value' => 'number_format($data->getTotalWithoutGST(), 2)',
           // 'filter' => CHtml::listData(MasterCustomer::model()->findAll(array('order' => 'mcusnam')), 'mcussno', 'mcusnam'),
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'type' => 'raw',
            'footer'=>$model->footerTemplate(),
        ),
        array(
            'header' => 'Cost',
            'value' => 'number_format($data->getItemCosts(), 2 )',
           // 'filter' => CHtml::listData(MasterCustomer::model()->findAll(array('order' => 'mcusnam')), 'mcussno', 'mcusnam'),
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'type' => 'raw',
            'footer'=>$model->footerTemplateCost(),
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))',
            'htmlOptions'=>array('style'=>'width:80px;text-align:center;')
        ),
        //'quotecreated',
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{print}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),               
                'print' => array(
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("quatation/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            )
        ),
    ),
));
?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=quatation/generateOutstandingJobsExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=quatation/printUnconvertedQuotePDF');

    }


</script>

<style>
    div .flowstatus{
        width: 3%;
        height: 1.5em;
        border: 1px solid #C9E0ED;             
        float: right;
        display: inline;
    }
    div .statuslbl{
        float: right;
    }  
</style>