<?php
$jobinfocusmenu = null;
$cancelQuoteMenu = null;
$createCopyMenu = null;
$deleteSequence = null; //Delete all data related to this quote including the quote itself
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}
if (Yii::app()->user->checkAccess('Quatation.Cancel')) {
    $cancelQuoteMenu = array('label' => 'Cancel', 'url' => array('Quatation/cancel', 'id' => $model->id), 'linkOptions' => array('style' => 'background-color:#CC3300', 'submit' => array('cancel', 'id' => $model->id), 'confirm' => 'Are you sure you want to cancel this quote?'));
}
if (Yii::app()->user->checkAccess('Quatation.CreateCopy')) {
    $createCopyMenu = array('label' => 'Create Copy', 'url' => array('Quatation/createCopy', 'id' => $model->id), 'linkOptions' => array('style' => 'background-color:#CC3300', 'submit' => array('createCopy', 'id' => $model->id), 'confirm' => 'Are you sure you want to create a copy from this quote?'));
}

if (in_array(Yii::app()->user->title, array('SuperAdmin'))) {
    $deleteSequence = array('label' => 'Delete Sequence', 'url' => array('Quatation/deleteSequence', 'id' => $model->id), 'linkOptions' => array('style' => 'background-color:#CC3300', 'submit' => array('deleteSequence', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this quote including all related data?'));
}

$this->menu = array(
    $deleteSequence,
    $jobinfocusmenu,
    $createCopyMenu,
    //array('label'=>'Update Quatation', 'url'=>array('update', 'id'=>$model->id)),
    //array('label'=>'Delete Quatation', 'url'=>'#', 'linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?')),
    array('label' => 'Update Quotation', 'url' => array('quatation/update', 'id' => $model->id)),
    array('label' => 'Create Sales Order', 'url' => array('#', 'quoteID' => $model->id), 'linkOptions' => array('class' => "create-so-link-btn", 'quote-id' => $model->id)),
    $cancelQuoteMenu,
    array('label' => 'Manage Quotation', 'url' => array('admin')),
);
?>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<h1>View Quotation : <?php echo $model->quoteno; ?></h1>
<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">

    <li class="active"><a href="#header-sec" role="tab" data-toggle="tab" onclick="setTab('header-sec');">Header Details</a></li>

    <li><a href="#crm-sec" role="tab" data-toggle="tab" onclick="setTab('crm-sec');">CRM</a></li>

    <li><a href="#quote-dtl-sec" role="tab" data-toggle="tab" onclick="setTab('quote-dtl-sec');">Quotation Details</a></li>

    <li><a href="#file-attachment-sec" role="tab" data-toggle="tab" onclick="setTab('file-attachment-sec');">File Attachments</a></li>

    <li><a href="#sign-off-sec" role="tab" data-toggle="tab" onclick="setTab('sign-off-sec');">Sign Off Terms</a></li>

    <li><a href="#online-quote-accept-sec" role="tab" data-toggle="tab" onclick="setTab('online-quote-accept-sec');">Online Quote Accept Log</a></li>

    <li><a href="#all-in-one-sec" role="tab" data-toggle="tab" onclick="setTab('all-in-one-sec');">All</a></li>



</ul>
<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="header-sec" style="padding-top: 0;margin-top: 0;">
        <div id="load-feel" class="loadfeel"></div>
        <div id="header-sec-wrap">
            <?php include '_header_section.php'; ?>
        </div>

    </div>
    <div class="tab-pane view" id="crm-sec" style="padding-top: 0;margin-top: 0;">
        <div id="crm-sec-wrap">
            <?php include '_crm_section.php'; ?>
        </div>
    </div>
    <div class="tab-pane view" id="quote-dtl-sec" style="padding-top: 0;margin-top: 0;">
        <div id="quote-dtl-sec-wrap">
            <?php include '_quote_dtl_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="file-attachment-sec" style="padding-top: 0;margin-top: 0;">
        <div id="file-attachment-sec-wrap">
            <?php include '_file_attachment_section.php'; ?>
        </div>
    </div>


    <div class="tab-pane view" id="sign-off-sec" style="padding-top: 0;margin-top: 0;">
        <div id="sign-off-sec-wrap">
            <?php include '_sign_off_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="online-quote-accept-sec" style="padding-top: 0;margin-top: 0;">
        <div id="online-quote-accept-sec-wrap">
            <?php include '_online_quote_accept_log_section.php'; ?>
        </div>
    </div>



    <div class="tab-pane view" id="all-in-one-sec" style="padding-top: 0;margin-top: 0;">

    </div>

</div>






<div style="float: right;">
    <?php
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)", 'style' => 'float:right;'));
    //echo CHtml::button('Print Kulbardi PDF', array('onclick' => "printKulbardiPDF($model->id)",'style'=>'float:right;background-color:#C45C1B;'));
    echo CHtml::button('Send Quotation', array('onclick' => "sendEmail($model->id,'Quote')", 'style' => 'float:right;'));
    ?>
</div>

<style>
    #quatation-details-grid table thead tr th {
        background-image: none;
        background-color: #82B8D6;

    }

    .loadfeel {
        position: absolute;
        border-top: 2px solid #82B8D6;
        width: 0%;
        margin-top: 0;
        margin: 0;
        padding: 0;
        left: 10px;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script>
    $(document).on('click', '.create-so-link-btn', function() {

        createSalesOrder($(this).attr('quote-id'));

        return false;

    });

    function createSalesOrder(quoteId) {
        bootbox.prompt({
            title: 'Confirmation!',
            message: '<p>Only create Sales Order for items accepted by client?</p>',
            inputType: 'radio',
            inputOptions: [                
                {
                    text: 'No, Create Sales Order for all items',
                    value: '1'
                },
                {
                    text: 'Yes, Only create Sales Order for items accepted by client',
                    value: '2'
                },
            ],
            callback: function(result) {
                if(result) {
                    window.location.href = `index.php?r=workorder/create&quoteID=${quoteId}&mode=${result}`;
                }
                
            }
        });

        return false;
    }

    function setTab(id) {
        if (id == 'all-in-one-sec') {
            runloadfeel('all-in-one-sec');
            $('#header-sec-wrap').appendTo('#all-in-one-sec');
            $('#crm-sec-wrap').appendTo('#all-in-one-sec');
            $('#quote-dtl-sec-wrap').appendTo('#all-in-one-sec');
            $('#file-attachment-sec-wrap').appendTo('#all-in-one-sec');
            $('#sign-off-sec-wrap').appendTo('#all-in-one-sec');
        } else if (id == 'header-sec') {
            runloadfeel('header-sec');
            $('#header-sec-wrap').appendTo('#header-sec');
        } else if (id == 'crm-sec') {
            runloadfeel('crm-sec');
            $('#crm-sec-wrap').appendTo('#crm-sec');
        } else if (id == 'quote-dtl-sec') {
            runloadfeel('quote-dtl-sec');
            $('#quote-dtl-sec-wrap').appendTo('#quote-dtl-sec');
        } else if (id == 'file-attachment-sec') {
            runloadfeel('file-attachment-sec');
            $('#file-attachment-sec-wrap').appendTo('#file-attachment-sec');
        } else if (id == 'sign-off-sec') {
            runloadfeel('sign-off-sec');
            $('#sign-off-sec-wrap').appendTo('#sign-off-sec');
        }

    }

    function runloadfeel(into) {
        $('#load-feel').appendTo('#' + into);

        $('#load-feel').css('width', '0');
        $('#load-feel').animate({
            width: '97.8%'
        }, 500);
    }

    function getPDFInputOptions() {
        var options = {};
        options.selected = ['totaldetails=1', 'withGrp=1'];
        options.inputOptions = [{
                text: 'With Grouping',
                value: 'withGrp=1',
            },
            {
                text: 'Total Details',
                value: 'totaldetails=1',
            },
        ];

        return options;
    }

    function printPDF(id) {
        var options = getPDFInputOptions();
        bootbox.prompt({
            title: "PDF Print Options",
            value: options.selected,
            inputType: 'checkbox',
            inputOptions: options.inputOptions,
            callback: function(result) {
                if (result) {
                    let query = 'index.php?r=quatation/print&id=' + id;
                    $.each(result, function(index, value) {
                        query += '&' + value;
                    });
                    var win = window.open(query);
                }
            }
        });

        //var win = window.open('index.php?r=quatation/print&id=' + id);
    }

    function printKulbardiPDF(id) {

        var win = window.open('index.php?r=quatation/print&id=' + id + '&tempt=2');
    }

    function sendEmail(id, emailtype) {
        var options = getPDFInputOptions();
        bootbox.prompt({
            title: "Send Quote - PDF Print Options",
            value: options.selected,
            inputType: 'checkbox',
            inputOptions: options.inputOptions,
            callback: function(result) {
                if (result) {
                    let query = 'index.php?r=emails/create&id=' + id + '&type=' + emailtype;
                    $.each(result, function(index, value) {
                        query += '&' + value;
                    });
                    var win = window.open(query);
                }
            }
        });
        //var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
    }

    $(document).ready(function() {
        $('#quote-detail input,#quote-detail textarea,#quote-detail select, #quote-detail-contact input').change(function() {
            var strid = $(this).attr('id');
            var arr = strid.split('_');
            var value = $(this).val();


            updateQuoteField(arr[1], arr[0], value)

        });
    });


    function updateQuoteField(id, field, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatation/updateQuoteField"); ?>',
            data: {
                'id': id,
                'field': field,
                'value': value
            },
            dataType: 'json',
            success: function(result) {

                if (result.success == true) {
                    changessaved(id, field);
                }
            },
            error: function(result) {
                console.log('error in update');
            }
        });
    }

    function updateQuoteName(id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatation/updateQuoteName"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {

                if (result.success == true) {
                    changessaved(id, 'savequotename');
                }
            },
            error: function(result) {
                alert('error in update');
            }
        });
    }

    function updateQuoteComent(id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatation/updateQuoteComent"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {

                if (result.success == true) {
                    changessaved(id, 'savecomments');
                }
            },
            error: function(result) {
                alert('error in update');
            }
        });
    }

    function changessaved(id, field) {
        $('#savemsg_' + field + '_' + id).fadeIn(500).fadeOut(1500);
    }

    $(document.body).on('change', '#copyOfficeAddrToShip', function() {
        if ($(this).is(':checked')) {
            copyCustomerOfficeAddressToShippingAddress(officeAddressObj());
        }
    });

    /* fire this event when change input name begin with 'customer' */
    $(document.body).on('change', "input[name^='customer']", function() {
        if ($('#copyOfficeAddrToShip').is(':checked')) {
            copyCustomerOfficeAddressToShippingAddress(officeAddressObj());
        }
    });

    function officeAddressObj() {
        var officeAddr = {};

        officeAddr.customerName = $("a[name='customer.cusnam']").html();
        officeAddr.customerContact = $("div[name='customer.cuscontact']").html();
        officeAddr.add1 = $("input[name='customer.cusadd1']").val();
        officeAddr.add2 = $("input[name='customer.cusadd2']").val();
        officeAddr.add3 = $("input[name='customer.cusadd3']").val();
        officeAddr.city = $("input[name='customer.custown']").val();
        officeAddr.state = $("input[name='customer.cusstate']").val();
        officeAddr.postalCode = $("input[name='customer.cuspostcode']").val();
        officeAddr.landPhone = $("input[name='customer.custel']").val();
        officeAddr.mobilePhone = $("input[name='customer.cusmobtel']").val();
        officeAddr.fax = $("input[name='customer.cusfax']").val();
        officeAddr.email = $("input[name='customer.cusemail']").val();

        return officeAddr;
    }

    function copyCustomerOfficeAddressToShippingAddress(officeAddrObj) {
        let customerContact = officeAddrObj.customerContact ? officeAddrObj.customerContact : officeAddrObj.customerName;
        $("input[name='shipContactName']").val(customerContact);
        $("input[name='shipAddress1']").val(officeAddrObj.add1);
        $("input[name='shipAddress2']").val(officeAddrObj.add2);
        $("input[name='shipAddress3']").val(officeAddrObj.add3);
        $("input[name='shipSub']").val(officeAddrObj.city);
        $("input[name='shipState']").val(officeAddrObj.state);
        $("input[name='shipPostalCode']").val(officeAddrObj.postalCode);

        $("input[name^='ship']").trigger("change"); /*trigger all input begin with name 'ship' */
        $('.field-success').fadeOut(1500);
    }
</script>