<?php
Yii::app()->clientScript->registerScript('searchQuoteItems', "

$('.quatation-item-details-form form').submit(function(){
	$.fn.yiiGridView.update('quatation-item-details-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>
<div class="quatation-item-details-form">
    <div class="form view">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'action' => Yii::app()->createUrl($this->route),
            'method' => 'get',
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <div class="row">
            <?php echo $form->labelEx($model, 'quote_number_search'); ?>
            <?php echo $form->textField($model, 'quote_number_search'); ?>
            <?php echo $form->error($model, 'quote_number_search'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'customer_search'); ?>
            <?php echo $form->textField($model, 'customer_search'); ?>
            <?php echo $form->error($model, 'customer_search'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'productsku'); ?>
            <?php echo $form->textField($model, 'productsku'); ?>
            <?php echo $form->error($model, 'productsku'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'productname'); ?>
            <?php echo $form->textField($model, 'productname'); ?>
            <?php echo $form->error($model, 'productname'); ?>
        </div>
        <div class="clear"></div> 
        <div class="row buttons">
            <?php echo CHtml::submitButton('Search'); ?>
        </div>
        <div class="clear"></div> 
        <?php $this->endWidget(); ?>
    </div><!-- form -->
</div>
<?php

$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'quatation-item-details-grid',
    'dataProvider' => $model->searchForSelectPopup(),
    'filter' => $model,
    'selectableRows' => 100,
    'filter' => null,
    'columns' => array(
        array(
            'class' => 'CCheckBoxColumn',
        ),
        array(
            'name' => 'quote_number_search',
            'value' => '$data->quotationRel->quoteno'
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->quotationRel->customer->cusnam'
        ),
        'productsku',
        'productname',
        'productdescription',
        array(
            'header' => 'Decoration',
            'value' => '$data->getMultiDecoHtml()',
            'type' => 'html'
        ),
        'qty',
        'sellunitprice_ex_vat',
        'sellunitprice_in_vat',
        'selltot_ex_vat',
        'selltot_in_vat',
    ),
));
?>
