<?php
    if(!SystemOptions::getOptions()->enablePaypalPayment) {
        echo '<h1>Payment gateway has been disabled!</h1>';
        echo '<p>Please contact admin.</p>';
        exit;
    }

    $paypalClientId = trim(SystemOptions::getOptions()->paypalClientId);
    $paypalCurrency = trim(SystemOptions::getOptions()->paypalCurrency);
?>

<h1>Online Quotation Checkout : <?php echo $quote->quoteno; ?> </h1>

<div class="quote-template view">    
    <?php
    echo $quote_template;
    ?>
</div>
<div class="quote-checkout-response-success" style="border: 1px solid greenyellow;padding: 10px;text-align: center;display: none;margin-top: 2%;">
    <h3 class="success-response-message">&nbsp;</h3>
    <h4>Payment was Success!.</h4>
    <p style="text-align: center;">Confirmation will be sent to your email</p>
</div>
<div class="quote-checkout-response-error" style="border: 1px solid #EE5757;padding: 10px;color: #CC3300;text-align: center;display: none;margin-top: 2%;">
    <h3>Sorry! Payment was failed!</h3>
    <h4>&nbsp;</h4>
</div>
<input type="hidden" id="quote-acceptance-seceret" value="<?php echo $quote->onlineAcceptenceLog->link_secret; ?>"/>
<!-- AdS9T1sAXR7d6B878zW3XMxwqw9olw0JP8h8YBSgfBfCeuccLskBtDljU8Ux3wosf0FezzZ95smNyMIp -->
<script src="<?php echo 'https://www.paypal.com/sdk/js?client-id='.$paypalClientId.'&currency=' . $paypalCurrency;?>&enable-funding=paylater" ></script>
<script >
    let linkSecret = $('#quote-acceptance-seceret').val();
    paypal.Buttons({
        /*
         * client-id=Ab0Y216wbppDfPNFWZVkTJSDhAR7HnmqLbMremC5pXIiDS2t9wGf9j76FmP8lHhDNqW2nuoBtdi8OIMG
         style: {
         color: 'blue',
         shape: 'pill'
         },
         */
        createOrder: function(data, actions) {
            return actions.order.create({
                purchase_units: [{
                    amount: {
                        currency_code: "AUD",
                        value: $('#grandTotal').val(), // this value from quote templete
                    }
                }]
            });
        },
        onApprove: function(data, actions) {
            return actions.order.capture().then(function(details) {
                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl("quoteAccept/paypalCheckout"); ?>',
                    data: {
                        'quoteLinkSecret': linkSecret,
                        'paypalResponseJson': details
                    },
                    dataType: 'json',
                    success: function(result) {
                        if (result.status == 'COMPLETED') {
                            handleAcceptenceResponce(result);
                        } else {
                            handleAcceptenceResponce(result);
                        }
                    },
                    error: function(result) {
                        handleAcceptenceResponce(result);
                    }
                });
            });
        }
    }).render('#paypal-button');// this button on quote templete


    function handleAcceptenceResponce(response) {
        $('.success-response-message').text('');
        $('.quote-template').fadeOut(500);
        if (response.status == 'COMPLETED') {
            //$('.success-response-message').text(response.message);
            $('.quote-checkout-response-success').fadeIn(1000);
        } else {
            $('.quote-checkout-response-error h4').html(response.error);
            $('.quote-checkout-response-error').fadeIn(1000);
        }
    }
    
</script>