<?php

$this->widget('zii.widgets.grid.CGridView', array(
    'id' => (isset($crmGridId) ? $crmGridId : 'sales-log-grid'),
    'dataProvider' => $salesLog->search(),
    'filter' => null,
    'columns' => array(
        'id',
        //'quoteId',
        //'quoteNum',
        //'category',
        //'isIntrnl',
        //'isExtrnl',
        array(
            'name' => 'createdDtm',
            'value' => 'Refiner::getdatetext($data->createdDtm,GlobalVars::get("DateFormat"))',
        ),
        array(
            'name' => 'comments',
            'value' => 'nl2br($data->comments)',
            'type' => 'raw',
        ),
        array(
            'name' => 'followupSts_id',
            'value' => 'FollowupStatus::model()->findByPk($data->followupSts_id)->status',
        ),
        array(
            'name' => 'followupDtm',
            'value' => 'Refiner::getdatetext($data->followupDtm,GlobalVars::get("DateFormat"))',
        ),
        array(
            'name' => 'createdBy',
            'value' => '$data->user->username',
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{followed}{sep1}{copy}{sep2}{edit}',
            'buttons' => array(
                'followed' => array(
                    'label' => 'Complete',
                    'imageUrl' => false,
                    'click' => "function(){
                                    $.fn.yiiGridView.update('sales-log-grid', {
                                        type:'POST',
                                        url:$(this).attr('href'),
                                        success:function(data) {
                                              
 
                                              $.fn.yiiGridView.update('sales-log-grid');
                                        }
                                    })
                                    return false;
                              }",
                    'url' => 'Yii::app()->controller->createUrl("salesLog/followedUp",array("id"=>$data->id))',
                    'visible' => '$data->isFollowUp() && $data->followedUp == false',
                ),
                'sep1' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                    'visible' => '$data->isExtrnl &&  !$data->isIntrnl &&  !$data->isTechnical ',
                ),
                'copy' => array(
                    'label' => 'Copy',
                    'imageUrl' => false,
                    'click' => "function(){
                        $.fn.yiiGridView.update('sales-log-grid', {
                                        type:'POST',
                                        url:$(this).attr('href'),
                                        success:function(data) {
                                                const result = JSON.parse(data);
                                                
                                                $('#sales-log-form #SalesLog_comments').val(result.comments);
                                                $('#sales-log-form #SalesLog_followupDtm').val(result.followupDtm);
                                                $('#sales-log-form #SalesLog_followupSts_id').val(result.followupSts_id);
                                                
                                                //scroll down to the form section
                                                const aTag = $('#sales-log-form');
                                                $('html,body').animate({scrollTop: aTag.offset().top}, 1000);
                                                
                                                //refresh grid to prevent showing loading gif
                                                $.fn.yiiGridView.update('sales-log-grid');
                                        }
                                    });
                                    return false;
                              }",
                    'url' => 'Yii::app()->controller->createUrl("salesLog/fetchData",array("id"=>$data->id))',
                    'visible' => '$data->isExtrnl &&  !$data->isTechnical ',
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                    'visible' => '$data->isExtrnl  &&  !$data->isTechnical ',
                ),
                'edit' => array(
                    'label' => 'Edit',
                    'imageUrl' => false,
                    'click' => "function(){
                        $.fn.yiiGridView.update('sales-log-grid', {
                                        type:'POST',
                                        url:$(this).attr('href'),
                                        success:function(data) {
                                                 $('#edit-crm-record-model').modal('show').css(
                                                    {
                                                        'margin-top': function() {
                                                            return -($(this).height() / 2);
                                                        },
                                                        'margin-left': function() {
                                                            return -($(this).width() / 2);
                                                        },
                                                    });
                                                 $.fn.yiiGridView.update('sales-log-grid');
                                                 
                                                 //setting form data
                                                 const result = JSON.parse(data);
                                                 console.log(result.id);   
                                                 $('#sales-log-update-form #SalesLog_id').val(result.id);
                                                 $('#sales-log-update-form #SalesLog_isIntrnl').prop('checked', +result.isIntrnl);
                                                 $('#sales-log-update-form #SalesLog_comments').val(result.comments);
                                                 $('#sales-log-update-form #SalesLog_followupDtm').val(result.followupDtm);
                                                 $('#sales-log-update-form #SalesLog_createdDtm').val(result.createdDtm);
                                                 $('#sales-log-update-form #SalesLog_followupSts_id').val(result.followupSts_id);
                                                 console.log($('#sales-log-update-form #SalesLog_id').val());   
                                        }
                                    });
                                    return false;
                              }",
                    'url' => 'Yii::app()->controller->createUrl("salesLog/fetchData",array("id"=>$data->id))',
                    'visible' => '$data->isExtrnl &&  !$data->isIntrnl &&  !$data->isTechnical ',
                ),
            ),
        ),
    ),
));
?>
