<?php
$this->breadcrumbs = array(
    'Sales Logs' => array('index'),
    'Manage',
);

$this->menu = array(
        //array('label'=>'List SalesLog', 'url'=>array('index')),
        //array('label'=>'Create SalesLog', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('sales-log-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Contact Resources </h1>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'sales-log-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name' => 'createdDtm',
            'value' => 'Refiner::getdatetext($data->createdDtm,GlobalVars::get("DateFormat"))'
        ),
        array(
            'name' => 'customer_search',
            'value' => '!empty($data->quote->customer)?$data->quote->customer->cusnam : ""'
        ),
        'quoteNum',
        array(
            'name' => 'sonum_search',
            'value' => '!empty($data->salesorder)?$data->salesorder->salesorderNumber : ""'
        ),
        array(
            'name' => 'category',
            'filter'=>CHtml::dropDownList('SalesLog[category]', $model->category,  
                array(
                    ''=>'',
                    'Quotation'=>'Quotation',
                    'SalesOrder'=>'Sales Order',
                    'Job'=>'Jobs',
                    'Invoice'=>'Invoice',
                    'PurchaseOrder'=>'Purchase Order',
                    'Other'=>'Other'                    
                )
            ),
            'value' => '$data->getLinkCategory()',
            'type' => 'raw',
           
        ),
        
        array(
            'name' => 'comments',
            'type' => 'raw',
        ),
        array(
            'name' => 'flwupsts_search',
            'value' => '!empty($data->flwupstus)?$data->flwupstus->status : ""'
        ),
        array(
            'name' => 'followupDtm',
            'value' => 'Refiner::getdatetext($data->followupDtm,GlobalVars::get("DateFormat"))',
        ),
//        array(
//            'name' => 'isIntrnl',
//            'value' => '$data->isIntrnl == 1 ? "Yes" : "No"'
//        ),
//        array(
//            'name' => 'isExtrnl',
//            'value' => '$data->isExtrnl == 1 ? "Yes" : "No"'
//        ),
//        array(
//            'name' => 'isTechnical',
//            'value' => '$data->isTechnical == 1 ? "Yes" : "No"'
//        ),
        
        /*
          'isIntrnl',
          'isExtrnl',
          'isTechnical',
          'followupSts_id',
          'createdDtm',
          'followupDtm',
          'createdBy',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{crm}{sep2}{followed}',
            'buttons' => array(
                'view' => array(
                    'label' => 'view',
                    'imageUrl' => false,                    
                    'options' => array('target' => '_blank'),
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,      
                    
                ),
                'crm' => array(
                    'label' => 'CRM',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("customer/view", array("id"=> $data->getCustomerID() ))',
                    'options' => array('target' => '_blank'),
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'imageUrl' => false,      
                    'visible' => '$data->isFollowUp() && $data->followedUp == false',
                ),
                'followed' => array(
                    'label' => 'Complete',
                    'imageUrl' => false,
                    'click' => "function(){
                                    $.fn.yiiGridView.update('sales-log-grid', {
                                        type:'POST',
                                        url:$(this).attr('href'),
                                        success:function(data) {
                                              
 
                                              $.fn.yiiGridView.update('sales-log-grid');
                                        }
                                    })
                                    return false;
                              }",
                    'url' => 'Yii::app()->controller->createUrl("followedUp",array("id"=>$data->id))',
                    'visible' => '$data->isFollowUp() && $data->followedUp == false',
                ),                
            ),
        ),
    ),
));
?>
