<?php
$this->breadcrumbs=array(
	'Sales Logs'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List SalesLog', 'url'=>array('index')),
	array('label'=>'Create SalesLog', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('sales-log-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Contacts Resource </h1>



<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'sales-log-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		array(
                    'name'=>'customer_search',
                    'value'=>'!empty($data->quote->customer)?$data->quote->customer->cusnam : ""'
                ),
                'quoteNum',
                array(
                    'name'=>'workorderId',
                    'value'=>'!empty($data->salesorder)?$data->salesorder->salesorderNumber : ""'
                ),
		'category',
		array(
                    'name'=>'comments',
                    'type'=>'raw',
                ),
                array(
                    'name'=>'followupSts_id',
                    'value'=>'!empty($data->flwupstus)?$data->flwupstus->status : ""'
                ),
                array(
                    'name'=>'followupDtm',
                    'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->followupDtm))',    
                    
                ),
                
                array(
                    'name'=>'isIntrnl',
                    'value'=>'$data->isIntrnl == 1 ? "Yes" : "No"'
                ),
                array(
                    'name'=>'isExtrnl',
                    'value'=>'$data->isExtrnl == 1 ? "Yes" : "No"'
                ),
                array(
                    'name'=>'isTechnical',
                    'value'=>'$data->isTechnical == 1 ? "Yes" : "No"'
                ),
                array(
                    'name'=>'createdDtm',
                    'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
                ),
		/*
		'isIntrnl',
		'isExtrnl',
		'isTechnical',
		'followupSts_id',
		'createdDtm',
		'followupDtm',
		'createdBy',
		*/
		array(
			'class'=>'CButtonColumn',
                        'template' => '{crm}{sep}{delete}',
                        'buttons' => array(
                            'crm' => array(
                                'label' => 'CRM',
                                'imageUrl' => false,
                                'url' => 'Yii::app()->createUrl("customer/view", array("id"=> $data->getCustomerID() ))',
                                'options' => array('target' => '_blank'),    
                            ),
                            'sep' => array(
                                'label' => ' | ',
                                'imageUrl' => false,
                                'visible'=>'$data->isExtrnl',
                ),
                            'delete' => array(
                                'label' => 'Delete',
                                'imageUrl' => false,
                                'visible'=>'$data->isExtrnl',
                            ),
                        ),
		),
	),
)); ?>
