<?php




Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('sales-log-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Customer Follow-Up Report </h1>



<?php 
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'sales-log-grid',
	'dataProvider'=>$model->cusfollowup(),
	'filter'=>$model,
	'columns'=>array(
		'id',
                array(
                    'name'=>'createdDtm',
                    'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
                ),
		array(
                    'name'=>'customer_search',
                    'value'=>'$data->getCustomerLink()'
                ),
                array(
                    'name'=>'followupDtm',
                    'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->followupDtm))',    
                    
                ),
                array(
                    'name'=>'followupSts_id',
                    'value'=>'!empty($data->flwupstus)?$data->flwupstus->status : ""'
                ),
                array(
                    'name'=>'createdBy',
                    'value'=>'$data->user->username'
                    
                ),               
               array(
                   'name'=>'followedUp',
                   'value'=>'$data->followedUp ? "YES" : "NO"',
                   'filter' => array('0' => 'NO','1' => 'YES'),
                   'htmlOptions'=>array('style'=>'text-align:center;')
               ),
		array(
			'class'=>'CButtonColumn',
                        'template' => '{crm}{sep}{done}{revoke}',
                        'buttons' => array(
                            'crm' => array(
                                'label' => 'CRM',
                                'imageUrl' => false,
                                'url' => 'Yii::app()->createUrl("customer/view", array("id"=> $data->getCustomerID() ))',
                                'options' => array('target' => '_blank'),    
                            ),
                            'sep' => array(
                                'label' => ' | ',
                                'imageUrl' => false,
                                
                ),
                            'done' => array(
                                'label' => 'Done',
                                'imageUrl' => false,
                                'click'=>"function(){
                                    $.fn.yiiGridView.update('sales-log-grid', {
                                        type:'POST',
                                        url:$(this).attr('href'),
                                        success:function(data) {
                                              
 
                                              $.fn.yiiGridView.update('sales-log-grid');
                                        }
                                    })
                                    return false;
                              }",
                               'url'=>'Yii::app()->controller->createUrl("followedUp",array("id"=>$data->id))', 
                                'visible'=>'$data->followedUp != true',
                            ),
                            'revoke' => array(
                                'label' => 'Revoke',
                                'imageUrl' => false,
                                'click'=>"function(){
                                    $.fn.yiiGridView.update('sales-log-grid', {
                                        type:'POST',
                                        url:$(this).attr('href'),
                                        success:function(data) {
                                              
 
                                              $.fn.yiiGridView.update('sales-log-grid');
                                        }
                                    })
                                    return false;
                              }",
                               'url'=>'Yii::app()->controller->createUrl("followedUp",array("id"=>$data->id))', 
                                'visible'=>'$data->followedUp == true',
                            ),
                        ),
		),
	),
));

?>
