<?php
$this->menu = array(
    //array('label'=>'List SalesPerson', 'url'=>array('index')),
    array('label' => 'Create Sales Person', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('sales-person-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Sales people</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'sales-person-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        array(
            'name' => 'id',
            'htmlOptions' => array('style' => 'width:5%;')
        ),
        'name',
        'title',
        'email',
        array(
            'name' => 'signature_image',
            'type' => 'raw',
            'value' => '$data->signature_image ? CHtml::image("images/salesperson/" . $data->signature_image, "", array("width" => 100)) : ""',
        ),
        array(
            'name' => 'is_active',
            'type' => 'boolean',
            'filter' => Yii::app()->format->booleanFormat,
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{update}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'update' => array(
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'delete' => array(
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
