<?php
$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}



Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Sales person Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'quote-summary-report-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <div class="row">

            <?php echo $form->labelEx($model, 'reportDateFlag'); ?>

            <?php
            echo $form->radioButtonList($model, 'reportDateFlag', array(1 => 'Quote Created Date', 2 => 'Quote Due Date'), array(
                'labelOptions' => array('style' => 'display:inline'),
                'separator' => '&nbsp;&nbsp;',
            ));
            ?>
        </div>
        <div class="clear"></div>

        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <?php echo $form->labelEx($model, 'id'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['qs_sperson_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['qs_sperson_selcted']);
                foreach ($stsArr as $key => $val) {
                    $optionsselected[$val] = array('selected' => true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'id', CHtml::listData(SalesPerson::model()->findAll(array('order' => 'name asc')), 'id', 'name'), 
					array(
						'empty' => 'Select Sales Persons', 
						'multiple' => true,
						'options' => $optionsselected
                
                    )
            );
            ?>
            <?php echo $form->error($model, 'id'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        <div class="clear"></div>


        <div style="float: left;">
            <?php
            echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
            echo CHtml::submitButton('Go', array('name' => 'go_btn'));
            ?>
        </div>
        <?php $this->endWidget(); ?>
        <div style="float: right;">
			<div style="display: inline;margin-right: 5px;">
				<?php
				echo CHtml::checkBox('estimateShow', true, array('id' => 'estimateShow', 'style' => 'display: inline;'));
				?>
				<label style="width:150px;display: inline;">
				<?php echo 'Show Estimate'; ?> 
				</label>
			</div>
			<div style="display: inline;margin-right: 5px;">
				<?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>
			</div>
					

        </div>

        <div class="clear"></div>
    </div>
</div>
<div class="clear"></div>



<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'quote-summary-report-grid',
	'dataProvider'=>$model->searchQuoteSum(),
	'filter'=>null,
	'columns'=>array(
		array(
			'name' => 'name',
			'value' => 'ucwords($data->name)', 
			'type' => 'html',
            'footer' => '<div style="text-align:right"><font style="font-size:1.2em;font-weight:bold">Total</font></div>',
		),
		array(
			'name' => 'sumSalesEstimate',
			'value' => 'number_format($data->sumSalesEstimate, 2)',
			'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'html',
            'footer' => '<div style="text-align:right"><font style="font-size:1.2em;font-weight:bold">'.number_format($model->grandSalesEstimate,2).'</font></div>',
		),	
		array(
			'name' => 'sumSellTotalExGST',
			'value' => 'number_format($data->sumSellTotalExGST, 2)',
			'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'html',
            'footer' => '<div style="text-align:right"><font style="font-size:1.2em;font-weight:bold">'.number_format($model->grandSumExGST,2).'</font></div>',
		),
		array(
			'name' => 'sumSellTotalIncGST',
			'value' => 'number_format($data->sumSellTotalIncGST, 2)',
			'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'html',
            'footer' => '<div style="text-align:right"><font style="font-size:1.2em;font-weight:bold">'.number_format($model->grandSumIncGST,2).'</font></div>',
		),
		
			
	),
)); ?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=salesPerson/');

    }

    function generatePDF() {
		var estimateShow = $('#estimateShow').is(':checked');
        var win = window.open('index.php?r=salesPerson/quotationSummaryPDF&estimateShow='+estimateShow);

    }


</script>

<style>
    div .flowstatus{
        width: 3%;
        height: 1.5em;
        border: 1px solid #C9E0ED;             
        float: right;
        display: inline;
    }
    div .statuslbl{
        float: right;
    }  
</style>