<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'sign-off-log-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($signoffLog); ?>

    <div class="row">
        <?php
        if (isset($_GET['r']) && $_GET['r'] == 'purchaseOrders/view') {
            ?>
            <?php echo $form->label($signoffLog, 'Delivery Code'); ?>
        <?php } else { ?>
            <?php echo $form->labelEx($signoffLog, 'sign_off_id'); ?>
        <?php } ?>
        <?php
        echo $form->dropDownList($signoffLog, 'sign_off_id',
				CHtml::listData(
						SignOffTerms::model()->findAll(
								array(
									'condition' => "model = '{$signoffLog->model}'", 
									'order' => 'FIELD(sign_off_id,\'SHIPPING ADDRESS [BUILT-IN-TERM]\',\'OFFICE ADDRESS [BUILT-IN-TERM]\') DESC, sign_off_id ASC')), 'id', 'sign_off_id'), array('empty' => 'Select Term'));
        ?>
        <?php echo $form->error($signoffLog, 'sign_off_id'); ?>
    </div>		

    <div class="row">
        <?php echo $form->textfield($signoffLog, 'model', array('style' => 'display:none;')); ?>
        <?php echo $form->textfield($signoffLog, 'model_id', array('style' => 'display:none;')); ?>

        <?php
        if (isset($_GET['r']) && $_GET['r'] == 'purchaseOrders/view') {
            ?>

            <?php echo $form->label($signoffLog, 'Delivery Details'); ?>
           

            <?php
        } else {
            ?>
            <?php echo $form->labelEx($signoffLog, 'sign_off_terms'); ?>
            


        <?php } ?>
        <?php echo $form->textArea($signoffLog, 'sign_off_terms', array('rows' => 6, 'cols' => 80, 'style' => 'width:450px;')); ?>
        <?php echo $form->error($signoffLog, 'sign_off_terms'); ?>
    </div>
    <div class="clear"></div>
    <div class="buttons">
        <?php echo CHtml::submitButton('Save', array('onclick' => 'javascript: saveSignOff();return false;', 'style' => 'float:right;')); ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->


<script>
    $(document).ready(function() {
        $("#SignOffLog_sign_off_id").change(function() {

            if (this.value != '') {


                $.ajax({
                    type: "POST",
                    url: '<?php echo Yii::app()->createUrl("signOffTerms/filterSignOffs"); ?>',
                    data: {'signoff_id': this.value, 'model' : $('#SignOffLog_model').val(), 'model_id': $('#SignOffLog_model_id').val()},
                    dataType: 'json',
                    success: function(data) {
                        //alert(data);
                        $("#SignOffLog_sign_off_terms").val(data.signoff_term);



                    },
                    error: function(data) {
                        alert('error');
                    },
                });

            } else {
                $("#SignOffLog_sign_off_terms").val('');
            }
        });
    });


    function saveSignOff() {

        var fd = new FormData($("#sign-off-log-form")[0]);
        //var comments = $("#SalesLog_comments").val();
        //fd.append("SalesLog[comments]", comments);
        //alert(comments);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("signOffLog/log"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {

                $.fn.yiiGridView.update("sign-off-log-grid");

            },
            complete: function() {
                // success alerts
            },
            error: function(data) {
                alert("There may a error on saving. Try again later");
            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }

</script>