<?php
$this->breadcrumbs = array(
    'Sign Off Terms' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label' => 'List SignOffTerms', 'url' => array('index')),
    array('label' => 'Create Sign Off Terms', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('sign-off-terms-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Sign Off Terms</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'sign-off-terms-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        'sign_off_id',
        'term',
        array(
            'name'=>'model',
            'filter'=>CHtml::dropDownList('SignOffTerms[model]', $model->model,  
					SignOffTerms::SIGN_OFF_CATEGORIES_ARRAY,
					array('empty'=>'-- Select --')
            ),
        ),
        
        array(
            'name' => 'createddate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createddate))'
        ),
        array(
            'name' => 'createdby',
            'value' => 'User::model()->findByPk($data->createdby)->username'
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
					
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
					'visible'=>'strpos($data->sign_off_id, "BUILT-IN-TERM") !== false ? false : true',
					
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
					'visible'=>'strpos($data->sign_off_id, "BUILT-IN-TERM") !== false ? false : true',
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
					'visible'=>'strpos($data->sign_off_id, "BUILT-IN-TERM") !== false ? false : true',
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
					'visible'=>'strpos($data->sign_off_id, "BUILT-IN-TERM") !== false ? false : true',
                ),
            )
        ),
    ),
));
?>
