<?php
$this->breadcrumbs = array(
    'Sub Artwork Jobs' => array('index'),
    'Manage',
);

$this->menu = array(
    ///array('label'=>'List SubArtworkJob', 'url'=>array('index')),
    array('label' => 'Create New', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('sub-artwork-job-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Sub Artwork Jobs</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'sub-artwork-job-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        array(
            'name'=>'jobCategory',
            'filter'=>CHtml::listData(SubArtworkJob::getProductCategories(),'name','value'),
        ),
        'productCategory',
        'name',
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,                   
                    
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                    
                ),
                'update' => array(
                    'label' => 'Update',
                    'imageUrl' => false,
                    
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                    
                ),
                'delete' => array(
                    'label' => 'Delete',
                    'imageUrl' => false,
                    
                ),
            ),
        ),
    ),
));
?>
