<?php
$this->breadcrumbs=array(
	'Supplier Product Logs'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List SupplierProductLog', 'url'=>array('index')),
	array('label'=>'Create SupplierProductLog', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('supplier-product-log-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Supplier Product Logs</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'supplier-product-log-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'supplier_id',
		'uploaded_product_count',
		'uploaded_product_id_json',
		'created_at',
		'created_by',
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
