<h1>System Options</h1>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<div class="form">

    <?php
   
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'settings-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
    <h4>General Settings</h4>
    <div class="view">

        <div class="row">
            <?php echo $form->labelEx($model, 'quoteToJob'); ?>
            <?php echo $form->checkBox($model, 'quoteToJob'); ?>
            <?php echo $form->error($model, 'quoteToJob'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'showPageID'); ?>
            <?php echo $form->checkBox($model, 'showPageID'); ?>
            <?php echo $form->error($model, 'showPageID'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'showPageID'); ?>
            <?php echo $form->checkBox($model, 'showPageID'); ?>
            <?php echo $form->error($model, 'showPageID'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'salesPersonSignatureOnQuotePDF'); ?>
            <?php echo $form->checkBox($model, 'salesPersonSignatureOnQuotePDF'); ?>
            <?php echo $form->error($model, 'salesPersonSignatureOnQuotePDF'); ?>
        </div>
        <div class="clear"></div>

        <div class="row">
            <?php echo $form->labelEx($model, 'defaultImagePath'); ?>
            <?php echo $form->textField($model, 'defaultImagePath', array('style' => 'width:500px;')); ?>
            <?php echo $form->error($model, 'defaultImagePath'); ?>
        </div>
        <div class="clear"></div>
        <?php
        $loadingImg = '<span id="remoteimg-loading-div" style="display:none;"><img class="loading-myob" src="images/loading.gif" style="width:35px;height:35px;">&nbsp;Please wait! System is trying to fetch images...</span>';
        $errorMessage = '<span id="remoteimg-error-div" style="color:red;display:none;">&nbsp;Error occurred during remote image saving!</span>';
        echo CHtml::button('Save Remote Images on Local [ 10 @ a time ]', array('onclick' => 'remoteImageSaverClient();return false;', 'title' => 'This will fetch remote images for product, quote details and SO details and save them on local.')) . $loadingImg . $errorMessage;
        ?>

        <div class="clear"></div>

        <div class="row">
            <?php echo $form->labelEx($model, 'logoImageUploadInstance'); ?>
            <?php echo $form->fileField($model, 'logoImageUploadInstance', array('size' => 60, 'maxlength' => 255)); ?>
            <?php echo $form->error($model, 'logoImageUploadInstance'); ?>
        </div>

        <div class="row">
            <?php
                if($logoImage = SystemOptions::getOptions()->logoImage) {
                    echo CHtml::image("images/logos/{$logoImage}", $logoImage, array('title' => 'Logo Image',  'style' => 'max-width:250px;max-height:150px;'));
                }
            ?>
        </div>

        <div class="clear"></div>

        <div class="row">
            <?php echo $form->labelEx($model, 'defaultPdfLogoUploadInstance'); ?>
            <?php echo $form->fileField($model, 'defaultPdfLogoUploadInstance', array('size' => 60, 'maxlength' => 255)); ?>
            <?php echo $form->error($model, 'defaultPdfLogoUploadInstance'); ?>
        </div>

        <div class="row">
            <?php            
                if($defaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage) {
                    echo CHtml::image("images/logos/{$defaultPdfLogoImage}", $defaultPdfLogoImage, array('height'=>100, 'title' => 'PDF Logo Image'));
                }
            ?>
        </div>

        <div class="clear"></div>
    </div>    
    <h4>Quotation Settings</h4>
    <div class="view">

        <div class="row">
            <?php echo $form->labelEx($model, 'quoteLockSellPrice'); ?>
            <?php echo $form->checkBox($model, 'quoteLockSellPrice'); ?>
            <?php echo $form->error($model, 'quoteLockSellPrice'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'maxWebServiceQuoteExecutePerOneRefresh'); ?>
            <?php echo $form->textField($model, 'maxWebServiceQuoteExecutePerOneRefresh'); ?>
            <?php echo $form->error($model, 'maxWebServiceQuoteExecutePerOneRefresh'); ?>
        </div>
        <div class="clear"></div>
        <div style="width: 90%;">
            <h4>Match Quote Online Acceptance status with Follow-up Status</h4>
            <div class="row">
                <?php echo $form->labelEx($model, 'quoteAcceptanceLinkSent'); ?>
                <?php echo $form->dropDownList($model, 'quoteAcceptanceLinkSent', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::QUOTATION . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'quoteAcceptanceLinkSent'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'quoteAcceptanceLinkAccept'); ?>
                <?php echo $form->dropDownList($model, 'quoteAcceptanceLinkAccept', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::QUOTATION . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'quoteAcceptanceLinkAccept'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'quoteAcceptanceLinkDecline'); ?>
                <?php echo $form->dropDownList($model, 'quoteAcceptanceLinkDecline', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::QUOTATION . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'quoteAcceptanceLinkDecline'); ?>
            </div>
            <div class="clear"></div>
        </div>



        <div class="clear"></div>
        <hr>
        <h5>Placeholders for Quotation Email Template</h5>
        <br>
        <p><b>QUOTE_NUMBER</b> : Represent the quotation number.</p>
        <p><b>ONLINE_ACCEPTANCE_LINK</b> : Represent the auto generated link to accept the quote via online.</p>
        <p><b>SALESPERSON</b> : Represent the salesperson related to the quotation.</p>
        <div class="clear"></div>
    </div> 
    <h4>Sales Order Settings</h4>
    <div class="view">

        <div class="row">
            <?php echo $form->labelEx($model, 'soLockSellPrice'); ?>
            <?php echo $form->checkBox($model, 'soLockSellPrice'); ?>
            <?php echo $form->error($model, 'soLockSellPrice'); ?>
        </div>
        <div class="clear"></div>
        <div style="width: 90%;">
            <h4>Match Sales Order Online Acceptance status with Follow-up Status</h4>
            <div class="row">
                <?php echo $form->labelEx($model, 'soAcceptanceLinkSent'); ?>
                <?php echo $form->dropDownList($model, 'soAcceptanceLinkSent', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::SALES_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'soAcceptanceLinkSent'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'soAcceptanceLinkAccept'); ?>
                <?php echo $form->dropDownList($model, 'soAcceptanceLinkAccept', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::SALES_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'soAcceptanceLinkAccept'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'soAcceptanceLinkDecline'); ?>
                <?php echo $form->dropDownList($model, 'soAcceptanceLinkDecline', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::SALES_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'soAcceptanceLinkDecline'); ?>
            </div>
            <div class="clear"></div>
        </div>




        <div class="clear"></div>
        <hr>
        <h5>Placeholders for Sales Order Email Template</h5>
        <br>
        <p><b>SO_NUMBER</b> : Represent the sales order number.</p>
        <p><b>ONLINE_ACCEPTANCE_LINK</b> : Represent the auto generated link to accept the sales order via online.</p>
        <p><b>SALESPERSON</b> : Represent the salesperson related to the sales order.</p>
        <div class="clear"></div>
    </div> 

    <h4>Web Store Order Settings</h4>
    <div class="view">



        <div style="width: 90%;">
            <h4>Match Web Store Order Online Acceptance status with Follow-up Status</h4>
            <div class="row">
                <?php echo $form->labelEx($model, 'webstoreOrderAcceptanceLinkSent'); ?>
                <?php echo $form->dropDownList($model, 'webstoreOrderAcceptanceLinkSent', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::WEBSTORE_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'webstoreOrderAcceptanceLinkSent'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'webstoreOrderAcceptanceLinkAccept'); ?>
                <?php echo $form->dropDownList($model, 'webstoreOrderAcceptanceLinkAccept', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::WEBSTORE_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'webstoreOrderAcceptanceLinkAccept'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'webstoreOrderAcceptanceLinkDecline'); ?>
                <?php echo $form->dropDownList($model, 'webstoreOrderAcceptanceLinkDecline', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::WEBSTORE_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
                <?php echo $form->error($model, 'webstoreOrderAcceptanceLinkDecline'); ?>
            </div>
            <div class="clear"></div>
        </div>




        <div class="clear"></div>
        <hr>
        <h5>Placeholders for Web Store Order Email Template</h5>
        <br>
        <p><b>WEBSTORE_NUMBER</b> : Represent the sales order number.</p>
        <p><b>ONLINE_ACCEPTANCE_LINK</b> : Represent the auto generated link to accept the sales order via online.</p>

        <div class="clear"></div>
    </div> 
    <h4>Job Settings</h4>
    <div class="view">
        <div class="row">
            <?php echo $form->labelEx($model, 'jobDueUrgentAuto'); ?>
            <?php echo $form->checkBox($model, 'jobDueUrgentAuto'); ?>
            <?php echo $form->error($model, 'jobDueUrgentAuto'); ?>
        </div>
        <div class="clear"></div>
        
        <hr>
        <h5>Placeholders for Follow-up status change - Job Auto Email Template</h5>
        <br>
        <p><b>JOB_NUMBER</b> : Represent the job order number.</p>
        <p><b>FOLLOW_UP_STATUS</b> : Represent the current follow-up status.</p>
        

        <div class="clear"></div>
    </div>    
    <h4>Purchase Order Settings</h4>
    <div class="view">
        <div class="clear"></div>

        <h5>Common PO Settings</h5>

        <div class="row">
            <?php echo $form->labelEx($model, 'show_price_on_pdf'); ?>
            <?php echo $form->checkBox($model, 'show_price_on_pdf'); ?>
            <?php echo $form->error($model, 'show_price_on_pdf'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_product_cost'); ?>
            <?php echo $form->checkBox($model, 'show_product_cost'); ?>
            <?php echo $form->error($model, 'show_product_cost'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_so_customisation'); ?>
            <?php echo $form->checkBox($model, 'show_so_customisation'); ?>
            <?php echo $form->error($model, 'show_so_customisation'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_customisation_details'); ?>
            <?php echo $form->checkBox($model, 'show_customisation_details'); ?>
            <?php echo $form->error($model, 'show_customisation_details'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_notes'); ?>
            <?php echo $form->checkBox($model, 'show_notes'); ?>
            <?php echo $form->error($model, 'show_notes'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_job_info'); ?>
            <?php echo $form->checkBox($model, 'show_job_info'); ?>
            <?php echo $form->error($model, 'show_job_info'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_website_ordering_info'); ?>
            <?php echo $form->checkBox($model, 'show_website_ordering_info'); ?>
            <?php echo $form->error($model, 'show_website_ordering_info'); ?>
        </div>

        <hr>
        <h5>Decoration PO Settings</h5>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_decoration'); ?>
            <?php echo $form->checkBox($model, 'show_decoration'); ?>
            <?php echo $form->error($model, 'show_decoration'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_decoration_cost'); ?>
            <?php echo $form->checkBox($model, 'show_decoration_cost'); ?>
            <?php echo $form->error($model, 'show_decoration_cost'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'show_logo_setup'); ?>
            <?php echo $form->checkBox($model, 'show_logo_setup'); ?>
            <?php echo $form->error($model, 'show_logo_setup'); ?>
        </div>
        <div class="clear"></div>
        <hr>
        <h5>Map PO Follow-Up Status with System Status</h5>
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'poFollowupStatusForCancel'); ?>
             <?php echo $form->dropDownList($model, 'poFollowupStatusForCancel', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::PURCHASE_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'poFollowupStatusForCancel'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'poFollowupStatusForCompleted'); ?>
             <?php echo $form->dropDownList($model, 'poFollowupStatusForCompleted', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type='" . FollowupStatus::PURCHASE_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'poFollowupStatusForCompleted'); ?>
        </div>
        <div class="clear"></div>
    </div> 
     <h4>Invoice Settings</h4>
    <div class="view">
        <div class="column">
            <?php echo $form->labelEx($model, 'payment_type_days'); ?>
            <?php echo $form->textField($model, 'payment_type_days', array('size' => 50, 'maxlength' => 50)); ?>
            <?php echo $form->error($model, 'payment_type_days'); ?>
        </div>
        <div class="column">
            <?php echo $form->labelEx($model, 'payment_type_id'); ?>
            <?php echo $form->dropDownList($model, 'payment_type_id', CHtml::listData(PaymentTerm::model()->findAll(array('order' => 'description ASC')), 'id', 'description'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'payment_type_id'); ?>
        </div>
        <div class="clear"></div>
    </div>
    <h4>Accounting Packages</h4>
    <div class="view">
        <div class="row">
            <?php echo $form->labelEx($model, 'enbleXero'); ?>
            <?php echo $form->checkBox($model, 'enbleXero'); ?>
            <?php echo $form->error($model, 'enbleXero'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'enableMyob'); ?>
            <?php echo $form->checkBox($model, 'enableMyob'); ?>
            <?php echo $form->error($model, 'enableMyob'); ?>
        </div>
        <div class="clear"></div>
    </div>
    <h4>FTP - Product Upload</h4>
    <div class="view">
        <label>FTP locations : </label>
        <?php
        $loadingImg = '<span id="ftp-loading-div" style="display:none;"><img class="loading-myob" src="images/loading.gif" style="width:35px;height:35px;">&nbsp;You will be redirected to the product page shortly!</span>';
        $errorMessage = '<span id="ftp-error-div" style="color:red;display:none;">&nbsp;Error occurred during FTP product refreshing!</span>';
        echo CHtml::button('Run FTP Prodcuts Upload ', array('onclick' => 'refreshFTPProducts();return false;')) . $loadingImg . $errorMessage;
        ?>
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'ftpProductRemoteServerFtpIP'); ?>
            <?php echo $form->textField($model, 'ftpProductRemoteServerFtpIP', array('style' => '')); ?>
            <?php echo $form->error($model, 'ftpProductRemoteServerFtpIP'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'ftpProductRemoteServerFtpUser'); ?>
            <?php echo $form->textField($model, 'ftpProductRemoteServerFtpUser', array('style' => '')); ?>
            <?php echo $form->error($model, 'ftpProductRemoteServerFtpUser'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'ftpProductRemoteServerFtpPassword'); ?>
            <?php echo $form->textField($model, 'ftpProductRemoteServerFtpPassword', array('style' => '')); ?>
            <?php echo $form->error($model, 'ftpProductRemoteServerFtpPassword'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'ftpProductRemoteServerDIR'); ?>
            <?php echo $form->textField($model, 'ftpProductRemoteServerDIR', array('style' => '')); ?>
            <?php echo $form->error($model, 'ftpProductRemoteServerDIR'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'ftpLocalDirToSaveExcelFiles'); ?>
            <?php echo $form->textField($model, 'ftpLocalDirToSaveExcelFiles', array('style' => '')); ?>
            <?php echo $form->error($model, 'ftpLocalDirToSaveExcelFiles'); ?>
        </div>
        <div class="clear"></div>

    </div>
    <div class="clear"></div>
    <h4>GWS Product API</h4>
    <div class="view">
        <div class="row">
            <?php echo $form->labelEx($model, 'gwsApiRequestUrl'); ?>
            <?php echo $form->textField($model, 'gwsApiRequestUrl', array('style' => 'width:500px;')); ?>
            <?php echo $form->error($model, 'gwsApiRequestUrl'); ?>
        </div>
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'gwsApiUsername'); ?>
            <?php echo $form->textField($model, 'gwsApiUsername', array('style' => '')); ?>
            <?php echo $form->error($model, 'gwsApiUsername'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'gwsApiPassword'); ?>
            <?php echo $form->textField($model, 'gwsApiPassword', array('style' => '')); ?>
            <?php echo $form->error($model, 'gwsApiPassword'); ?>
        </div>
        <div class="clear"></div>
    </div>

    <div style="width: 100%;">
        <?php echo CHtml::submitButton('Save', array('style' => 'float:right;')); ?>
    </div>
    <div class="clear"></div>




    <?php $this->endWidget(); ?>

</div><!-- form -->
<script>

    function remoteImageSaverClient() {
        $('#remoteimg-loading-div').show();

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("systemOptions/remoteImageSaverClient"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) {
                $('#remoteimg-loading-div').hide();
                 $('#remoteimg-error-div').hide();
            },
            error: function (result) {
                $('#remoteimg-loading-div').hide();
                $('#remoteimg-error-div').show();
            }
        });
    }

    function refreshFTPProducts() {
        $('#ftp-loading-div').show();

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("systemOptions/ftpProductRead"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) {
                $('#ftp-loading-div').hide();
                $('#ftp-error-div').hide();
                window.location.href = "index.php?r=productLine/admin";
            },
            error: function (result) {
                $('#ftp-loading-div').hide();
                $('#ftp-error-div').show();
            }
        });
    }
</script>


