<div class="form view">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'template-text-form',
        'enableAjaxValidation' => false,
    ));
    ?>
    <p><span class="required">*</span> To check available placeholders for each template please check under settings.</p>
    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->labelEx($model, 'template_id'); ?>
        <?php
        echo $form->dropDownList(
            $model,
            'template_id',
            TemplateText::getTempleteList(),
            array(
                'empty' => ''
            )
        );
        ?>
        <?php echo $form->error($model, 'template_id'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'name'); ?>
        <?php echo $form->textField($model, 'name', array('size' => 60, 'maxlength' => 50)); ?>
        <?php echo $form->error($model, 'name'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'contents'); ?>
        <?php echo $form->textArea($model, 'contents', array('style' => 'width:650px;height:350px')); ?>
        <?php echo $form->error($model, 'contents'); ?>
    </div>

    <div class="clear"></div>

    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>
    <div class="clear"></div>
    <?php $this->endWidget(); ?>

</div><!-- form -->
<script src="https://cdn.tiny.cloud/1/0skwx0zckjr5gi6y1ydjqgw6ii9npl8qvvyhlae14aq1ow52/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '#TemplateText_contents'
    });
</script>