<?php
$this->menu = array(
    //array('label'=>'List TemplateText', 'url'=>array('index')),
    array('label' => 'Create Template Text', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('template-text-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Template Texts</h1>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'template-text-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name' => 'template_id',
            'value' => '$data->templateToString()',
        ),
        array(
            'name' => 'contents',
            'value' => 'substr($data->contents, 1, 100) . "..."', 
            'type' => 'html'
        ),
        'created_at',
        array(
            'name' => 'created_by',
            'value' => 'User::model()->findByPk($data->created_by)->username'
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
