<?php
$this->breadcrumbs=array(
	'Web Services'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List WebService', 'url'=>array('index')),
	array('label'=>'Create WebService', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('web-service-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Web Services</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'web-service-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'ws_id',
		'ws_quoteno',
		'ws_clientid',
		'ws_data',
		'ws_user',
		'ws_type',
		/*
		'ws_compyn',
		'ws_updflg',
		'ws_showflg',
		'ws_updflgsup',
		'ws_updflgprc',
		'ws_updflgmdec',
		'ws_qthsno',
		'ws_date',
		'ws_time',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
