<script>
    function hide(callID, hideID) {
        if ($('#' + hideID).is(":visible")) {
            $('#' + hideID).slideUp(500);
            $('#' + callID).attr("src", 'images/more_details.png');


        } else {
            $('#' + hideID).slideDown(500);
            $('#' + callID).attr("src", 'images/less_details.png');


        }
    }
</script>

<?php




$this->menu = array(
    //array('label'=>'List WebStore', 'url'=>array('index')),
    array('label' => 'Create', 'url' => array('create')),
    array('label' => 'Update', 'url' => array('update', 'id' => $model->id)),
    array('label' => 'Delete', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage', 'url' => array('admin')),
);
?>

<h1>View Web Store : <?php echo $model->name; ?></h1>
<input type="hidden" id="webstoreId" value="<?php echo $model->id; ?>"/>
<div class="view">


    <?php
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $model,
        'attributes' => array(
            'id',
            'name',
            'description',
            'createdDate',
            'createdBy',
        ),
    ));
    ?>
</div>
<div class="clear"></div>


<div class="view">
    <h3>Settings</h3>

    <ul class="nav nav-tabs" role="tablist">

        <li class="active"><a href="#general-sec" role="tab" data-toggle="tab" >General</a></li>

        <li><a href="#prod-cat-order" role="tab" data-toggle="tab" >Category Order</a></li>



    </ul>
    <div class="tab-content">
        <div class="tab-pane active view" id="general-sec" style="padding-top: 0;margin-top: 0;">
            <?php
            $this->widget('zii.widgets.CDetailView', array(
                'data' => $model,
                'attributes' => array(
                    array(
                        'name' => 'autoCreateJob',
                        'value' => CHtml::CheckBox('autoCreateJob', $model->autoCreateJob, array()) . "&nbsp;<span style='color:green;font-weight:bold;display:none;' id='savemsg_autoCreateJob'>Changes are saved</span>",
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'autoCreateInvoice',
                        'value' => CHtml::CheckBox('autoCreateInvoice', $model->autoCreateInvoice, array()) . "&nbsp;<span style='color:green;font-weight:bold;display:none;' id='savemsg_autoCreateInvoice'>Changes are saved</span>",
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'customerPriceLevel',
                        'value' => CHtml::dropDownList('customerPriceLevel', $model->customerPriceLevel, array('PRIVATE' => 'PRIVATE', 'BASE' => 'BASE', 'VIP' => 'VIP', 'Level C' => 'Level C', 'Level D' => 'Level D', 'Level E' => 'Level E', 'Level F' => 'Level F'), array('id' => 'webstore_customerPriceLevel')) . "&nbsp;<span style='color:green;font-weight:bold;display:none;' id='savemsg_customerPriceLevel'>Changes are saved</span>",
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'webOrdersEmail',
                        'value' => CHtml::textField('webOrdersEmail', $model->webOrdersEmail, array('id' => 'webstore_webOrdersEmail')) . "&nbsp;<span style='color:green;font-weight:bold;display:none;' id='savemsg_webOrdersEmail'>Changes are saved</span>",
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'pageItems',
                        'value' => CHtml::textField('pageItems', $model->pageItems, array('id' => 'webstore_pageItems')) . "&nbsp;<span style='color:green;font-weight:bold;display:none;' id='savemsg_pageItems'>Changes are saved</span>",
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'webstoreUrl',
                        'value' => CHtml::link($model->webstoreUrl, $model->webstoreUrl, array('target' => '_blank')),
                        'type' => 'raw',
                    ),
                ),
            ));
            ?>
        </div>
        <div class="tab-pane view" id="prod-cat-order" style="padding-top: 0;margin-top: 0;">
            <?php
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'product-category-grid',
                'dataProvider' => $productcategory->searchWebStoreOrder($model->id),
                'filter' => $productcategory,
                'columns' => array(
                    'id',
                    'name',
                    array(
                        'header' => 'Sort Order',
                        'type' => 'raw',
                        'value' => 'CHtml::textField("",$data->getWebstoreSortOrder('.$model->id.'),array("style"=>"text-align:center;", "id"=>$data->id,"name"=>"sort_order_number","onchange"=>"updateCategorySortOrder(this.id,this.value);"))',
                    ),
                //'createdDate',
                //'createdBy',
                ),
            ));
            ?>

        </div>
    </div>

</div>
<div class="clear"></div>
<div class="view">
    <div style="display: inline;float: right;" >
        <img id="selct-prod-webstr-hide-show" src="images/more_details.png" style="width: 20px;height: 20px;cursor: pointer;" onclick="hide(this.id, 'selt-prod-webstore-form');"/>
    </div>
    <h3>Select Products Groups for Web Store</h3>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'selt-prod-webstore-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('style' => 'display:none;')
    ));
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'choose-from-product-group-grid',
        'dataProvider' => $productGroup->searchForWebstore(),
        'filter' => $productGroup,
        'selectableRows' => 100,
        'columns' => array(
            array(
                'class' => 'CCheckBoxColumn',
            ),
            'short_desc',
            'long_desc',
            array(
                'name' => 'image',
                'type' => 'raw',
                'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
            ),
            'created_date',
            'created_by',
            array(
                'class' => 'CButtonColumn',
                'template' => '{view}{sep1}{update}',
                'buttons' => array(
                    'view' => array(
                        'label' => 'View',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("productGroup/view", array("id"=>$data->id))',
                    ),
                    'sep1' => array(
                        'label' => ' | ',
                        'imageUrl' => false,
                    ),
                    'update' => array(
                        'label' => 'Update',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("productGroup/update", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));
    ?>


    <div class="buttons">
        <?php echo CHtml::submitButton('Allocate Product Groups', array('name' => 'selct-prod-webstr-btn')); ?>
    </div>
    <div class="clear"></div>  
    <?php $this->endWidget(); ?>
</div>
<div class="clear"></div>  
<div class="view">
    <h3>Selected Products Groups</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'selected-product-group-grid',
        'dataProvider' => $webstoreproductgroup->search(),
        'filter' => null,
        'columns' => array(
            array(
                'header' => 'Short Desc',
                'value' => '$data->productGroupRel->short_desc'
            ),
            array(
                'header' => 'Long Desc',
                'value' => '$data->productGroupRel->long_desc'
            ),
            array(
                'header' => 'Image',
                'type' => 'raw',
                'value' => 'CHtml::image(($data->productGroupRel?$data->productGroupRel->getImg():""), "", array("width" => 100))',
            ),
            array(
                'name' => 'created_date',
                'value' => 'date("Y-m-d",strtotime($data->created_date))'
            ),
            array(
                'name' => 'created_by',
                'value' => 'User::model()->findByPk($data->created_by)->username'
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array(
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("webstoreProductGroup/delete", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));
    ?>

</div>

<div class="clear"></div>

<h3>Price Lists</h3>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'webstore-price-list-grid',
    'dataProvider' => $pricelist->search(),
    'filter' => $pricelist,
    'columns' => array(
        'id',
        'priceListName',
        'headerTxt',
        'comment',
        array(
            'name' => 'imageName',
            'type' => 'html',
            'value' => 'CHtml::image($data->getImg(), \'\', array(\'width\' => 100,\'max-height\' => 100))',
        ),
        'createdDate',
        /*
          'fileName',
          'isActive',
          'createdDate',
          'createdBy',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep0}{delete}{sep}{download}',
            'buttons' => array
                (
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstorePriceList/view", array("id"=>$data->id))',
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstorePriceList/update", array("id"=>$data->id))',
                ),
                'sep0' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstorePriceList/delete", array("id"=>$data->id))',
                ),
                'sep' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'download' => array
                    (
                    'label' => 'Download',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstorePriceList/downloadFile", array("id"=>$data->id))',
                ),
            ),
        ),
    ),
));
?>


<script>
    $(document).on('change', '#autoCreateJob,#autoCreateInvoice', function () {


        if ($(this).is(':checked')) {
            updateCheckBoxSetings($(this).attr('id'), 1);
        } else {
            updateCheckBoxSetings($(this).attr('id'), 0);
        }


    });

    function showSaveMessage(spanfield) {
        $('#savemsg_' + spanfield).fadeIn(10).fadeOut(2000);
    }

    $(document).on('change paste', '#webstore_customerPriceLevel', function () {

        updateWebStoreField('customerPriceLevel', $(this).val());
    });

    $(document).on('change paste', '#webstore_webOrdersEmail', function () {

        updateWebStoreField('webOrdersEmail', $(this).val());
    });

    $(document).on('change paste', '#webstore_pageItems', function () {

        updateWebStoreField('pageItems', $(this).val());
    });





    function updateWebStoreField(field, val) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("webStore/updateWebStoreField"); ?>',
            data: {'webstoreId': $('#webstoreId').val(), 'field': field, 'val': val},
            dataType: 'json',
            success: function (result) {
                showSaveMessage(field);
            },
            error: function (result) {
                // alert('Error in calculate sell price excluding GST!');
            }
        });
    }

    function updateCheckBoxSetings(attr, checked) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("webStore/updateCheckBoxSetings"); ?>',
            data: {'webstoreId': $('#webstoreId').val(), 'attr': attr, 'checked': checked},
            dataType: 'json',
            success: function (result) {
                showSaveMessage(attr);

            },
            error: function (result) {

            }
        });

    }
    
    function updateCategorySortOrder(id,value){
    $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productCategory/updateWebStoreSortOrder"); ?>',
            data: {'webstoreId': $('#webstoreId').val(), 'id': id, 'value': value},
            dataType: 'json',
            success: function(result) {
               
            },
            error: function(result) {
                alert('error in update size order');
            }
        });
}
</script>