<?php
$this->menu = array(
    array('label' => 'Home', 'url' => array('webStore/dashboard')),
    array('label'=>'My Orders', 'url'=>array('webstoreOrder/admin')),    
    array('label' => 'My Cart', 'url' => array('webstoreCart/viewCart')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('web-store-user-product-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Web Store User Products</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->
<div class="clear"></div>
<div class="view" >
    <div class="view" style="width: 20%;height: 100%;float: left;">
        <?php
        $form=$this->beginWidget('CActiveForm', array(
	'id'=>'prod-cat-menu-form',
	'enableAjaxValidation'=>false,
)); 
        $categories = ProductCategory::model()->findAll(array('order' => 'name asc'));
        foreach ($categories as $cat) {
            echo "<ul id='catul_{$cat->id}' class'prodcatmenu' >";
            $catcheckbox = CHtml::CheckBox("cat[$cat->id]", false, array('value' => $cat->id,'id'=>'cat_' . $cat->id, 'onclick'=>"filterCategory({$cat->id},null);")) . '<span>&nbsp;'. $cat->name . '</span>';
            echo "<li>{$catcheckbox}</li>";
            $subcategory = ProductSubCategory::model()->findAll(array('condition' => "productCategoryId = '{$cat->id}'"));
            echo '<ul>';
            foreach ($subcategory as $sub) {
                $subcatcheckbox = CHtml::CheckBox("subcat[$cat->id][$sub->id]", false, array('value' => $sub->id,'id'=>'subcat_' . $sub->id, 'onclick'=>"filterCategory({$cat->id},{$sub->id});")) . '<span>&nbsp;'. $sub->name . '</span>';
                echo "<li>{$subcatcheckbox}</li>";
            }
            echo '</ul>';
            echo '</ul>';
        }
        echo CHtml::submitButton( 'Save');
         $this->endWidget(); 
        ?>
    </div>
    <div style="width: 75%;float: right;">
        <?php
        $this->widget('zii.widgets.CListView', array(
            'dataProvider' => $model->search(),
            'itemView' => 'listgridview',
            'id'=>"webcus-prod-list",
        ));
        ?> 
    </div>
    <div class="clear"></div>
</div>


<script>
    /*listgridview related functions*/
    function addtocart(userproductID) {


        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("webstoreCart/addtocart"); ?>',
            data: {'userproductID': userproductID},
            dataType: 'json',
            success: function (result) {
                if (result.success == true) {
                    alert('Added to web cart!');
                } else if (result.success == false) {
                    alert('Failed add to web cart!');
                }
            },
            error: function (result) {
                alert('Error when add product to cart');
            }
        });
    }
    
    function filterCategory(catID,subcatID){
        //alert(catID);
        if(!$('#cat_'+catID).is(':checked') && subcatID !== null && $('#subcat_'+subcatID).is(':checked')){
            
            $('#cat_'+catID ).prop( "checked", true );
        }if(!$('#cat_'+catID).is(':checked') && subcatID === null){
            $('#catul_'+catID).find('input[type=checkbox]:checked').removeAttr('checked');
        }
        
        var fd = new FormData($("#prod-cat-menu-form")[0]);        
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("webStoreUserProduct/filterCategory"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {
                
                 $.fn.yiiListView.update("webcus-prod-list",{});
            },
            complete: function() {
                // success alerts
            },
            error: function(data) {
                alert("There is an error when filter by category");
            },
            cache: false,
            contentType: false,
            processData: false
        });
    }
    
</script>
<style>
    .prodcatmenu ul,li{
        list-style: none;
    }
</style>