<?php
$this->breadcrumbs = array(
    'Web Store User Products' => array('index'),
    $model->id,
);

$this->menu = array(
    array('label' => 'Home', 'url' => array('webStore/dashboard')),
    array('label' => 'Web Store', 'url' => array('webStoreUserProduct/admin')),
    array('label'=>'My Orders', 'url'=>array('webstoreOrder/admin')),   
    array('label' => 'My Cart', 'url' => array('webstoreCart/viewCart')),
);
?>

<h1>View WebStoreUserProduct #<?php echo $model->id; ?></h1>
<div class="view">
    <div style="float: left;width: 35%;">
        <img src="<?php echo $model->webstoreprodRel->productLineRel->getImg(); ?>" alt=""  />
        <div style="margin: auto;text-align: center;"><h3><?php echo $model->webstoreprodRel->productLineRel->pdlprdline; ?></h3></div>
    </div>
    <div style="float: right;width: 60%;">
        <?php
        $availableQty = !empty($model->webstoreprodRel->productLineRel->inventoryRel) ?
                $model->webstoreprodRel->productLineRel->inventoryRel->availableQty() : 0;

        $this->widget('zii.widgets.CDetailView', array(
            'data' => $model,
            'attributes' => array(
                //'id',

                array(
                    'label' => 'Name',
                    //'name'=>'webstoreprodRel.productLineRel.pdlprdline',
                    'value' => $model->webstoreprodRel->productLineRel->pdlprdline,
                ),
                array(
                    'label' => 'Code',
                    'value' => $model->webstoreprodRel->productLineRel->pdlpdl,
                ),
                array(
                    'label' => 'Details',
                    'name' => 'webstoreprodRel.productLineRel.pdldes',
                    'value' => $model->webstoreprodRel->productLineRel->pdldes,
                ),
                array(
                    'label' => 'Available Qty',
                    'value' => $availableQty,
                    'visible'=> ($model->webstoreprodRel->productLineRel->orderTypeId == 2)
                ),
            ///'userId',
            //'webstoreProductId',
            // 'createdDate',
            // 'createdBy',
            ),
        ));
        ?>
        <div style="width: 95%;" class="view">
            <h4 style="text-align: center;">Price Quantity Break Levels</h4>
            <?php
            $pdlsno = $model->webstoreprodRel->productLineRel->pdlsno;
            $prdprices = new ProductPrice();
            $prdprices->pdppdlsno = $pdlsno;
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'product-price-grid',
                'dataProvider' => $prdprices->searchPerPage(5),
                'filter' => null,
                'columns' => array(
                    'pdpquantity_break_level',
                    'pdpquantity',
                    'pdpsquantity',
                    array(
                        'name' => 'pdpsellprice',
                        'value' => 'number_format($data->pdpsellprice,2)'
                    ),
                //'pdppdlsno',
                //'pdpprinted',


                /*
                  'pdpprice',

                  'pdpucdnew',
                  'pdpentddt',
                  'pdpenttime',
                  'pdpucdame',
                  'pdpameddt',
                  'pdpametime',
                 */
                ),
            ));
            ?>
        </div>
        <?php 
            if(($model->webstoreprodRel->productLineRel->orderTypeId == 2 && $availableQty > 0) ||  $model->webstoreprodRel->productLineRel->orderTypeId == 1){
        ?>
        <div style="width: 100%;">
            <?php
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'webstore-cart-detail-form',
                'enableAjaxValidation' => false,
            ));
            echo CHtml::textField('availableQty', $availableQty, array('id' => 'availableQtyField', 'style' => 'display:none;'));
            echo CHtml::textField('WebstoreCartDetail[productId]', $model->webstoreprodRel->productLineRel->pdlsno, array('id' => 'productIDField', 'style' => 'display:none;'));
            echo CHtml::textField('WebstoreCartDetail[productPriceID]', $model->webstoreprodRel->productLineRel->pdlsno, array('id' => 'productPriceIDField', 'style' => 'display:none;'));
            echo CHtml::textField('WebstoreCartDetail[webstoreUserProdId]', $model->id, array('id' => 'webstoreUserProdIdField', 'style' => 'display:none;'));
            echo CHtml::label('My Qty :&nbsp;', '', array('style' => 'display:inline-block;'));
            if($model->webstoreprodRel->productLineRel->orderTypeId == 2 && $availableQty > 0){
                echo CHtml::textField('WebstoreCartDetail[requestQty]', '', array('id' => 'requetQtyField', 'style' => 'display:inline-block;width:15%;', 'onkeyup' => 'setPrice();'));
            }else if($model->webstoreprodRel->productLineRel->orderTypeId == 1){
                echo CHtml::textField('WebstoreCartDetail[requestQty]', '', array('id' => 'requetQtyField', 'style' => 'display:inline-block;width:15%;', 'onkeyup' => 'setPriceOnDemand();'));
            }
                
            echo CHtml::label('&nbsp;Price :&nbsp;', '', array('style' => 'display:inline-block;'));
            echo CHtml::textField('WebstoreCartDetail[sellingPrice]', '', array('id' => 'sellingPriceField', 'style' => 'display:inline-block;width:15%;', 'readonly' => true));
            echo CHtml::label('&nbsp;Total :&nbsp;', '', array('style' => 'display:inline-block;'));
            echo CHtml::textField('WebstoreCartDetail[lineAmount]', '', array('id' => 'lineAmountField', 'style' => 'display:inline-block;width:15%;', 'readonly' => true));

            echo '&nbsp;&nbsp;' . CHtml::submitButton('Add to Cart', array('style' => 'display:inline-block;width:15%;', 'onclick'=>'addtocart();return false;'));

            $this->endWidget();
            ?>



        </div>
        <?php 
            }
        ?>
    </div>
    <div class="clear"></div>
</div>
<script>
    function setPrice() {
        var qty = parseInt($('#requetQtyField').val());        
        var productID = $('#productIDField').val();

        if (validateForm()) {
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("productPrice/sellingPriceInQtyRange"); ?>',
                data: {'productID': productID, 'qty': qty},
                dataType: 'json',
                success: function (result) {
                    $('#sellingPriceField').val(result.prdSellPrice);
                    //$('#productPriceIDField').val(result.productPriceID);
                    $('#lineAmountField').val(result.lineAmount);
                },
                error: function (result) {
                    clearFormFields();
                    alert('Error in fetching price');
                }
            });
        } else {
            clearFormFields();
        }

    }
    
    function validateForm(){
        var qty = parseInt($('#requetQtyField').val());
        var avlQty = parseInt($('#availableQtyField').val());
        
        if (qty <= avlQty && qty > 0) {
            return true;
        }
        
        return false;
    }
    
    function validateFormOnDemand(){
        var qty = parseInt($('#requetQtyField').val());        
        
        
        if (qty > 0) {
            return true;
        }
        
        return false;
        
    }
    
    function validateFormOnSubmit(){
        var qty = parseInt($('#requetQtyField').val());       
        var sellingPrice = parseInt($('#sellingPriceField').val());
        if (qty > 0 && sellingPrice > 0) {
            return true;
        }
        
        return false;
    }
    
    function setPriceOnDemand() {
        var qty = parseInt($('#requetQtyField').val());        
        var productID = $('#productIDField').val();

        if (validateFormOnDemand()) {
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("productPrice/sellingPriceInQtyRange"); ?>',
                data: {'productID': productID, 'qty': qty},
                dataType: 'json',
                success: function (result) {
                    $('#sellingPriceField').val(result.prdSellPrice);
                    //$('#productPriceIDField').val(result.productPriceID);
                    $('#lineAmountField').val(result.lineAmount);
                },
                error: function (result) {
                    clearFormFields();
                    alert('Error in fetching price');
                }
            });
        } else {
            clearFormFields();
        }

    }

    function addtocart() {
        //var qty = parseInt($('#requetQtyField').val());
        //var avlQty = parseInt($('#availableQtyField').val());
        
        if (validateFormOnSubmit()) {

        var fd = new FormData($("#webstore-cart-detail-form")[0]);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("webstoreCart/addtocart"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function () {
                // do some loading options
            },
            success: function (result) {
               // window.location.href = '<?php echo Yii::app()->createUrl("webstoreCart/viewCart"); ?>';
            },
            complete: function () {
                window.location.href = '<?php echo Yii::app()->createUrl("webstoreCart/viewCart"); ?>';
            },
            error: function (data) {
                
            },
            cache: false,
            contentType: false,
            processData: false
        });
        
        }else{
            alert('Cannot proceed! Some values you provided are not valid!')
        }
        return false;
    }

    function clearFormFields() {
        $('#requetQtyField').val(0);
        $('#sellingPriceField').val(0);
        $('#productPriceIDField').val(0);
        $('#lineAmountField').val(0);
    }
</script>

