<?php
$this->menu = array(
    array('label' => 'Home', 'url' => array('webStore/dashboard')),
    array('label' => 'Web Store', 'url' => array('webStoreUserProduct/admin')),
    array('label'=>'My Orders', 'url'=>array('webstoreOrder/admin')),    
    
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('webstore-cart-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>


<h1>My Cart Details</h1>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'webstore-cart-details-grid',
    'dataProvider' => $webcartdetails->search(),
    'filter' => null,
    'columns' => array(
        'id',
        array(
            'header' => 'Image',
            'type' => 'raw',
            'value' => 'CHtml::image($data->webStoreUserProductRel->webstoreprodRel->productLineRel->getImg(), "", array("width" => 100))',
        ),
        array(
            'name' => 'Code',
            'value'=>'$data->webStoreUserProductRel->webstoreprodRel->productLineRel->pdlpdl',
        ),
        array(
            'name' => 'Name',
            'value'=>'$data->webStoreUserProductRel->webstoreprodRel->productLineRel->pdlprdline',
        ),
        array(
            'name' => 'Details',
            'value'=>'$data->webStoreUserProductRel->webstoreprodRel->productLineRel->pdldes',
            'htmlOptions'=>array('style'=>'width:350px;'),
        ),
        array(
            'name' => 'Quantity',
            'value'=>'$data->requestQty',
        ),
        array(
            'name' => 'Price',
            'value'=>'$data->sellingPrice',
        ),
        array(
            'name' => 'Line Amount',
            'value'=>'number_format($data->lineAmount,2)',
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{delete}',
            'buttons' => array(
                'delete' => array(
                    'label' => 'Delete',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstoreCartDetail/delete", array("id"=>$data->id))',
                ),
            )
        ),
    ),
));
?>
<div style="float: right;">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
                'id' => 'webstore-cart-form',
                'enableAjaxValidation' => false,
            ));
    echo CHtml::textField('WebstoreCart[id]', $model->id, array('id' => 'webstoreUserProdIdField', 'style' => 'display:none;'));
    echo CHtml::button("Cancel", array('onclick' => "cancelorder();",'style' => 'background-color:#CC3300','name'=>'order_cancel_btn'));
    echo CHtml::button("Place Order", array('onclick' => "placeorder();"));
    $this->endWidget();
    ?>

</div>
<script>
    function cancelorder(){
        var fd = new FormData($("#webstore-cart-form")[0]);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("webstoreCart/CancelOrder"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function () {
                // do some loading options
            },
            success: function (result) {
                
            },
            complete: function () {
                 window.location.replace('<?php echo Yii::app()->createUrl("webStoreUserProduct/admin"); ?>');
            },
            error: function (data) {
                alert("Cannot proceed! Some error occurred!");
            },
            cache: false,
            contentType: false,
            processData: false
        });
    }
    
    function placeorder(){
        var fd = new FormData($("#webstore-cart-form")[0]);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("webstoreCart/placeOrder"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function () {
                // do some loading options
            },
            success: function (result) {
                
            },
            complete: function () {
                 window.location.replace('<?php echo Yii::app()->createUrl("webstoreOrder/admin"); ?>');
            },
            error: function (data) {
                alert("Cannot proceed! Some error occurred!");
            },
            cache: false,
            contentType: false,
            processData: false
        });
    }
</script>