<?php
$this->breadcrumbs = array(
    'Webstore Orders' => array('index'),
    'Manage',
);

$this->menu = array(
        //array('label'=>'List WebstoreOrder', 'url'=>array('index')),
        //array('label'=>'Create WebstoreOrder', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('webstore-order-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Orders</h1>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'webstore-order-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
       array(
           'header'=> 'Customer ID',
           'value'=>'$data->getMYOBCustomerID()'
       ),
        array(
            'name' => 'createdDate',
            'value' => 'date("Y-m-d",strtotime($data->createdDate))'
        ),
        //'webstore_id',
        //'webstoreCartId',
        array(
            'name' => 'webstore_id',
            'value' => 'WebStore::model()->findByPk($data->webstore_id)->name',
        ),
        array(
            'name'=>'orderNumber',
            'value'=>'$data->orderNumber ."<br>" .$data->getJobsHtml()',
            'type'=>'raw'
        ),
        array(
            'name'=>'invoice_html',
            'value'=>'$data->getInvoicesHtml()',
            'type'=>'raw'
        ),
        array(
            'name' => 'webstore_user_id',
            'value' => '$data->getCustomer()->cusnam',
        ),
        //'webstore_user_id',
        'adminComment',
        array(
            'name' => 'estimatedDeliveryDate',
            'value' => '$data->estimatedDeliveryDate?date("Y-m-d",strtotime($data->estimatedDeliveryDate)):null'
        ),
        array(
            'name' => 'statusId',
            'value' => 'Status::model()->findByPk($data->statusId)->name'
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
