<?php
$orderReject = null;
$orderApprove = null;
$createJob = null;
$statusPending = Status::model()->find(array('condition' => "name = 'Pending Approval'"));
if (in_array($model->statusId, array($statusPending->id))) {
    $orderReject = array('label' => 'Reject Order', 'url' => array('webstoreOrder/reject', 'id' => $model->id), 'linkOptions' => array('style' => 'background-color:#CC3300', 'submit' => array('reject', 'id' => $model->id), 'confirm' => 'Are you sure you want to reject this order?'));
}

$statusRejected = Status::model()->find(array('condition' => "name = 'Rejected'"));
$statusConvertedJob = Status::model()->find(array('condition' => "name = 'Converted to Job'"));
if (in_array($model->statusId, array($statusPending->id)) && !in_array($model->statusId, array($statusRejected->id, $statusConvertedJob->id))) {
    $orderApprove = array('label' => 'Approve Order', 'url' => array('webstoreOrder/approve', 'id' => $model->id), 'linkOptions' => array('submit' => array('approve', 'id' => $model->id), 'confirm' => 'Are you sure you want to approve this order?'));
}

$statusApproved = Status::model()->find(array('condition' => "name = 'Approved'"));

if (in_array($model->statusId, array($statusApproved->id))) {
    $createJob = array('label' => 'Create Job', 'url' => array('webstoreOrder/createJob', 'id' => $model->id), 'linkOptions' => array('submit' => array('createJob', 'id' => $model->id), 'confirm' => 'Are you sure you want to create job?'));
}

$jobMenu = null;
$backOrderJobMenu = null;
$inventoryJobInvoiceMenu = null;
$backOrderInvoiceMenu = null;
$job = Jobs::model()->findByPk($model->jobId);
if ($job) {
    $jobMenu = array('label' => "On-Inventory : " . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
    if ($job->getInvoice()) {
        $inventoryJobInvoiceMenu = array('label' => $job->getInvoice()->invoiceNum, 'url' => array('invoice/view', 'id' => $job->getInvoice()->id));
    }
}

$backOrderJob = Jobs::model()->findByPk($model->backOrderJobId);
if ($backOrderJob) {
    $backOrderJobMenu = array('label' => "Back-Order : " . $backOrderJob->jobNum, 'url' => array('jobs/view', 'id' => $backOrderJob->id));
    if ($backOrderJob->getInvoice()) {
        $backOrderInvoiceMenu = array('label' => $backOrderJob->getInvoice()->invoiceNum, 'url' => array('invoice/view', 'id' => $backOrderJob->getInvoice()->id));
    }
}



$this->menu = array(
    $backOrderJobMenu,
    $backOrderInvoiceMenu,
    $jobMenu,
    $inventoryJobInvoiceMenu,
    $orderReject,
    $orderApprove,
    $createJob,
    //array('label'=>'Create WebstoreOrder', 'url'=>array('create')),
    //array('label'=>'Update WebstoreOrder', 'url'=>array('update', 'id'=>$model->id)),
    //array('label'=>'Delete WebstoreOrder', 'url'=>'#', 'linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?')),
    array('label' => 'Manage Orders', 'url' => array('admin')),
);
?>

<h1>View Order #<?php echo $model->id; ?></h1>
<input type="hidden" id="order_id" value="<?php echo $model->id; ?>" />
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<div class="view">
    <?php
    $statusCanceleld = Status::model()->find(array('condition' => "name = 'Cancelled'"));
    if ($model->statusId == $statusCanceleld->id) {
        echo '<h3 align="center" style="color: #CC0000;">[CANCELLED]</h3>';
    }
    $statusRejected = Status::model()->find(array('condition' => "name = 'Rejected'"));
    if ($model->statusId == $statusRejected->id) {
        echo '<h3 align="center" style="color: #CC0000;">[REJECETD]</h3>';
    }
    ?>
    <div style="width: 100%;">
        <div style="width: 50%;float: left;">
            <?php
            ob_start();
            $todayDate = date(GlobalVars::get("DateFormat")); // current date
            $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
            $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'estimatedDeliveryDate', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
                'htmlOptions' => array('style' => 'text-align:left;', "id" => "weborder_estimatedDeliveryDate"),
                'language' => 'en-GB'
            ));

            $estimatedDeliveryDatePicker = ob_get_contents();
            ob_end_clean();

            $customerMYOBID = "";
            if ($model->getCustomer() && $model->getCustomer()->master) {
                $customerMYOBID = $model->getCustomer()->master->displayIdMYOB;
            }
            $this->widget('zii.widgets.CDetailView', array(
                'data' => $model,
                'id' => 'order-detail',
                'attributes' => array(
                    array(
                        'label' => 'Customer ID',
                        'value' => $customerMYOBID,
                    ),
                    'orderNumber',
                    array(
                        'name' => 'webstore_id',
                        'value' => WebStore::model()->findByPk($model->webstore_id)->name,
                    ),
                    array(
                        'name' => 'webstore_user_id',
                        'value' => $model->getCustomer()->cusnam,
                    ),
                    array(
                        'name' => 'purchaseOrderNumber',
                        'value' => CHtml::textField('purchaseOrderNumber', $model->purchaseOrderNumber, array("style" => "width:300px;", "id" => "weborder_purchaseOrderNumber")) . '<span id="savemsg_purchaseOrderNumber" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'customerAccountNumber',
                        'value' => CHtml::textField('customerAccountNumber', $model->customerAccountNumber, array("style" => "width:300px;", "id" => "weborder_customerAccountNumber")) . '<span id="savemsg_customerAccountNumber" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'adminComment',
                        'value' => CHtml::textArea('adminComment', $model->adminComment, array("style" => "width:300px;", "rows" => 2, "id" => "weborder_adminComment")) . '<span id="savemsg_adminComment" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'estimatedDeliveryDate',
                        'value' => $estimatedDeliveryDatePicker . '<span id="savemsg_estimatedDeliveryDate" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'specialInstructions',
                        'value' => CHtml::textArea('specialInstructions', $model->specialInstructions, array("style" => "width:300px;", "rows" => 2, "id" => "weborder_specialInstructions")) . '<span id="savemsg_specialInstructions" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'officeAddress',
                        'value' => CHtml::textArea('officeAddress', $model->officeAddress, array("style" => "width:300px;", "rows" => 2, "id" => "weborder_officeAddress")) . '<span id="savemsg_officeAddress" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'suburb',
                        'value' => CHtml::textField('suburb', $model->suburb, array("style" => "width:300px;", "id" => "weborder_suburb")) . '<span id="savemsg_suburb" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'postalCode1',
                        'value' => CHtml::textField('postalCode1', $model->postalCode1, array("style" => "width:300px;", "id" => "weborder_postalCode1")) . '<span id="savemsg_postalCode1" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'state1',
                        'value' => CHtml::textField('state1', $model->state1, array("style" => "width:300px;", "id" => "weborder_state1")) . '<span id="savemsg_state1" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'customerTelephone',
                        'value' => CHtml::textField('customerTelephone', $model->customerTelephone, array("style" => "width:300px;", "id" => "weborder_customerTelephone")) . '<span id="savemsg_customerTelephone" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'customerEmail',
                        'value' => CHtml::textField('customerEmail', $model->customerEmail, array("style" => "width:300px;", "id" => "weborder_customerEmail")) . '<span id="savemsg_customerEmail" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'contactPerson1',
                        'value' => CHtml::textField('contactPerson1', $model->contactPerson1, array("style" => "width:300px;", "id" => "weborder_contactPerson1")) . '<span id="savemsg_contactPerson1" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'statusId',
                        'value' => Status::model()->findByPk($model->statusId)->name
                    ),
                    'statusUpdatedAt',
                    array(
                        'name' => 'statusChangedBy',
                        'value' => $model->statusChangedBy ? User::model()->findByPk($model->statusChangedBy)->username : null
                    ),
                    'createdDate'
                ),
            ));
            ?>
        </div>
        <div style="width: 50%;float: left;">
            <?php
            $this->widget('zii.widgets.CDetailView', array(
                'data' => $model,
                'id' => 'order-detail-2',
                'attributes' => array(
                    array(
                        'name' => 'isThirdpartyDelivery',
                        'value' => CHtml::checkBox('isThirdpartyDelivery', $model->isThirdpartyDelivery, array("style" => "width:300px;", "id" => "weborder_isThirdpartyDelivery")) . '<span id="savemsg_isThirdpartyDelivery" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'deliveryAddress',
                        'value' => CHtml::textArea('deliveryAddress', $model->deliveryAddress, array("style" => "width:300px;", "rows" => 2, "id" => "weborder_deliveryAddress")) . '<span id="savemsg_deliveryAddress" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'suburb2',
                        'value' => CHtml::textField('suburb2', $model->suburb2, array("style" => "width:300px;", "id" => "weborder_suburb2")) . '<span id="savemsg_suburb2" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'postalCode',
                        'value' => CHtml::textField('postalCode', $model->postalCode, array("style" => "width:300px;", "id" => "weborder_postalCode")) . '<span id="savemsg_postalCode" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'state',
                        'value' => CHtml::textField('state', $model->state, array("style" => "width:300px;", "id" => "weborder_state")) . '<span id="savemsg_state" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'customerTelephone2',
                        'value' => CHtml::textField('customerTelephone2', $model->customerTelephone2, array("style" => "width:300px;", "id" => "weborder_customerTelephone2")) . '<span id="savemsg_customerTelephone2" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'contactEmail',
                        'value' => CHtml::textField('contactEmail', $model->contactEmail, array("style" => "width:300px;", "id" => "weborder_contactEmail")) . '<span id="savemsg_contactEmail" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                    array(
                        'name' => 'contactPerson',
                        'value' => CHtml::textField('contactPerson', $model->contactPerson, array("style" => "width:300px;", "id" => "weborder_contactPerson")) . '<span id="savemsg_contactPerson" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                        'type' => 'raw',
                    ),
                ),
            ));
            ?>
        </div>
    </div>

    <div class="grid-view">
        <table class="items">
            <thead>
                <tr>
                    <th></th>
                    <th>Product</th>
                    <th style="text-align: center;">Quantity</th>
                    <th style="text-align: right;">Amount</th>

                </tr>   
            </thead>
            <tbody>



<?php
$cart = WebstoreCart::model()->findByPk($model->webstoreCartId);
$cartdetails = WebstoreCartDetail::model()->findAll(array('condition' => "webstoreCartId =  $model->webstoreCartId", 'group' => "colorGroupCode,isBackOrder"));
$count = 0;
$totQty = 0;
$totAmount = 0;
foreach ($cartdetails as $dtl) {
    $count++;
    $product = ProductLine::model()->findByPk($dtl->productId);
    $code = $product->pdlpdl;
    $codeSplitted = explode(".", $code);
    $styleNo = $codeSplitted[0];
    $productColorName = substr($product->pdlprdline, 0, strrpos($product->pdlprdline, " "));
    $groupQty = $cart->getGroupQty($dtl->colorGroupCode, $dtl->isBackOrder);
    $groupAmount = $cart->getGroupAmount($dtl->colorGroupCode, $dtl->isBackOrder);
    //$totQty += $groupQty;
    //$totAmount += $groupAmount;
    ?>

                    <tr id="itm-main-row-<?php echo $dtl->id; ?>">
                        <td><?php echo $count; ?></td>
                        <td style="font-size: 1.2em;padding: 5px;">
                            <img src="<?php echo $product->getImgForWebStore() ?: 'images\noimage.jpg'; ?>" style="max-height: 70px;max-width: 100px;float: left;"/>
                            <div style="max-height: 70px;">
    <?php echo $productColorName; ?><br>
                                <font style="font-size: 0.8em;font-weight: bold;">Colour Code : <?php echo $dtl->colorGroupCode; ?></font>
                                <?php
                                if ($dtl->isBackOrder) {
                                    echo '<br><font style="font-size: 0.8em;font-weight: bold;color: seagreen;">This will be placed on back order</font>';
                                }
                                ?>
                            </div>
                        </td>
                        <td style="font-size: 1.2em;padding: 5px;font-weight: bold;text-align: center;"><?php echo $groupQty; ?></td>
                        <td style="font-size: 1.2em;padding: 5px;font-weight: bold;text-align: right;"><?php echo number_format($groupAmount, 2); ?></td>

                    </tr>
                    <tr id="itm-qty-brk-row-<?php echo $dtl->id; ?>" style="border-bottom: solid 1px #808080;">
                        <td></td>
                        <td colspan="3">
    <?php
    echo $cart->getColorSizeQtyHtml($dtl->colorGroupCode, $dtl->isBackOrder);
    ?>
                        </td>

                    </tr>

    <?php
}

$totalIncludingGst = $model->totalExGst * $model->gstRate;
$gstAmount = $totalIncludingGst - $model->totalExGst;
$gstPercentage = $model->gstRate ? (($model->gstRate * 100) - 100) : 0;
$location_freight = $model->postal_code_freight_charge;
$grandTotal = $totalIncludingGst + $location_freight;
?>
            </tbody>
            <tfoot>
                <tr>
                    <td></td>
                    <td></td>
                    <td style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;">Sub Total</td>
                    <td id="tot-amount" style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;"><?php echo number_format($model->totalExGst, 2); ?></td>
                    <td></td>
                </tr> 
                <tr>       
                    <td></td>
                    <td></td>
                    <td style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;">GST ( <?php echo $gstPercentage; ?>% )</td>
                    <td  id="tot-gst" style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;"><?php echo number_format($gstAmount, 2); ?></td>
                    <td></td>
                </tr> 
                <tr>       
                    <td></td>
                    <td></td>
                    <td style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;">Freight</td>
                    <td  id="postal-location-freight" style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;"><input style="text-align: right;font-weight: bold;" type="text" id="postal_code_freight_charge" name="postal_code_freight_charge" value=" <?php echo number_format($location_freight, 2); ?>" /></td>
                    <td></td>
                </tr> 
                <tr>                        
                    <td colspan="3" style="text-align: right;font-size: 1.2em;font-weight: bold;">Total</td>
                    <td  id="grand-total" name="grand-total" style="text-align: right;font-size: 1.2em;font-weight: bold;"><?php echo number_format($grandTotal, 2); ?></td>
                    <td></td>
                </tr> 
            </tfoot>
        </table>
    </div>

</div>

<?php
echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)", 'style' => 'float: right;'));
//echo CHtml::button('Email Order', array('onclick' => "resendPDF($model->id)", 'style' => 'float: right;'));
?>
<script>

    function printPDF(id) {
        var win = window.open('index.php?r=webstoreOrder/print&id=' + id);
    }
    
    $(document).on('change paste', '#postal_code_freight_charge', function () {


        var strid = $(this).attr('id');       
        var value = $(this).val();

        
        updateQuoteField(strid, value);
        


    });


    $(document).on('change paste', '#order-detail input,textarea', function () {


        var strid = $(this).attr('id');
        var arr = strid.split('_');
        var value = $(this).val();

        if (strid == 'weborder_isThirdpartyDelivery') {
            if ($(this).is(":checked"))
            {
                updateQuoteField(arr[1], 1);
            } else {
                updateQuoteField(arr[1], 0);
            }
        } else {
            updateQuoteField(arr[1], value);
        }


    });

    $(document).on('change paste', '#order-detail-2 input,textarea', function () {


        var strid = $(this).attr('id');
        var arr = strid.split('_');
        var value = $(this).val();

        if (strid == 'weborder_isThirdpartyDelivery') {
            if ($(this).is(":checked"))
            {
                updateQuoteField(arr[1], 1);
            } else {
                updateQuoteField(arr[1], 0);
            }
        } else {
            updateQuoteField(arr[1], value);
        }


    });


    function updateQuoteField(field, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("webstoreOrder/updateField"); ?>',
            data: {'id': $('#order_id').val(), 'field': field, 'value': value},
            dataType: 'json',
            success: function (result) {
                
                if (result.success == 'true') {
                    showSaveMessage(field);
                    
                    
                    
                    $('#grand-total').empty();
                    $('#grand-total').html(result.grand_total);
                    
                    $('#postal_code_freight_charge').val(result.postal_code_freight_charge);
                    

                }

            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function showSaveMessage(spanfield) {
        $('#savemsg_' + spanfield).fadeIn(10).fadeOut(2000);
    }
</script>