

<h1 align="center">Web Order #<?php echo $model->orderNumber; ?></h1>
<?php 
$invJob = Jobs::model()->findByPk($model->jobId);
if($invJob){
    if($invJob->getInvoice()){
        echo '<h4 align="center">Invoice Number #'.$invJob->getInvoice()->invoiceNum.' <small>[Inventory]</small></h4>';
    }
}

$backorderJob = Jobs::model()->findByPk($model->backOrderJobId);
if($backorderJob){
    if($backorderJob->getInvoice()){
        echo '<h4 align="center">Invoice Number #'.$backorderJob->getInvoice()->invoiceNum.' <small>[Back Order]</small></h4>';
    }
}

?>
<?php
$statusCanceleld = Status::model()->find(array('condition' => "name = 'Cancelled'"));
if ($model->statusId == $statusCanceleld->id) {
    echo '<h3 align="center" style="color: #CC0000;">[CANCELLED]</h3>';
}
$statusRejected = Status::model()->find(array('condition' => "name = 'Rejected'"));
if ($model->statusId == $statusRejected->id) {
    echo '<h3 align="center" style="color: #CC0000;">[REJECETD]</h3>';
}

$customerMYOBID = "";
if ($model->getCustomer() && $model->getCustomer()->master) {
    $customerMYOBID = $model->getCustomer()->master->displayIdMYOB;
}
?>

<div >

    <div style="float: left; width: 50%;">

        <table style="width: 100%;font-size: 8pt;">
             <tr>
                <td style="width: 35%;color: #404040;">Customer ID</td>
                <td><?php echo $customerMYOBID; ?></td>
            </tr>
            <tr>
                <td style="width: 35%;color: #404040;">Order Number</td>
                <td><?php echo $model->orderNumber; ?></td>
            </tr>
            <tr>
                <td style="width: 35%;color: #404040;">Purchase Order</td>
                <td><?php echo $model->purchaseOrderNumber; ?></td>
            </tr>
            <tr>
                <td style="width: 35%;color: #404040;">Account Number</td>
                <td><?php echo $model->customerAccountNumber; ?></td>
            </tr>
            
            <tr>
                <td style="color: #404040;">Admin Comment</td>
                <td><?php echo $model->adminComment ?: ""; ?></td>
            </tr>
            
            <tr>
                <td style="color: #404040;">Special Instructions</td>
                <td><?php echo nl2br($model->specialInstructions); ?></td>
            </tr>
            
            <?php 
                if($model->jobId){
            ?>
            <tr>
                <td style="width: 35%;color: #404040;">Inventory Job</td>
                <td><?php echo Jobs::model()->findByPk($model->jobId)->jobNum; ?></td>
            </tr>
            <?php 
                }
            ?>
            <?php 
                if($model->backOrderJobId){
            ?>
            <tr>
                <td style="width: 35%;color: #404040;">Back Order Job</td>
                <td><?php echo Jobs::model()->findByPk($model->backOrderJobId)->jobNum; ?></td>
            </tr>
             <?php 
                }
            ?>
            
            <tr>
                <td style="color: #404040;">Status</td>
                <td><?php echo Status::model()->findByPk($model->statusId)->name; ?></td>
            </tr>
        </table>


    </div>

    <div style="float: right;">

        <table style="width: 100%;font-size: 8pt;">
            <tr>
                <td style="text-align: right;color: #404040;">Created Date</td>
                <td style="text-align: right;"><?php echo Refiner::getdatetext($model->createdDate, 'Y-m-d'); ?></td>
            </tr>
            <tr>
                <td style="color: #404040;;">Estimated Delivery Date</td>
                <td><?php echo Refiner::getdatetext($model->estimatedDeliveryDate, 'Y-m-d'); ?></td>
            </tr>
            <tr>
                <td style="text-align: right;color: #404040;">Web Store</td>
                <td style="text-align: right;"><?php echo WebStore::model()->findByPk($model->webstore_id)->name; ?></td>
            </tr>
            
            <tr>
                <td style="color: #404040;text-align: right;">Web Store User</td>
                <td style="text-align: right;"><?php echo $model->getCustomer()->cusnam; ?></td>
            </tr>
            
            <tr>
                <td style="vertical-align:top;color: #404040;text-align: right;">Delivery Address</td>
                <td style="text-align: right;">
                    <?php
                    $address = "";
                    if ($model->isThirdpartyDelivery) {
                        if (trim($model->deliveryAddress)) {
                            $address = nl2br($model->deliveryAddress);
                            if (trim($model->suburb2)) {
                                $address .= '<br>' . $model->suburb2;
                            }
                            if (trim($model->postalCode)) {
                                $address .= '<br>' . $model->postalCode;
                            }

                            if (trim($model->state)) {
                                $address .= '<br>' . $model->state;
                            }
                        } else {
                            $address = nl2br($model->officeAddress);
                            if (trim($model->suburb)) {
                                $address .= '<br>' . $model->suburb;
                            }
                            if (trim($model->postalCode1)) {
                                $address .= '<br>' . $model->postalCode1;
                            }

                            if (trim($model->state1)) {
                                $address .= '<br>' . $model->state1;
                            }
                        }
                    } else {
                        if (trim($model->officeAddress)) {
                            $address = nl2br($model->officeAddress);
                            if (trim($model->suburb)) {
                                $address .= '<br>' . $model->suburb;
                            }
                            if (trim($model->postalCode1)) {
                                $address .= '<br>' . $model->postalCode1;
                            }

                            if (trim($model->state1)) {
                                $address .= '<br>' . $model->state1;
                            }
                        } else {
                            $address = nl2br($model->deliveryAddress);
                            if (trim($model->suburb2)) {
                                $address .= '<br>' . $model->suburb2;
                            }
                            if (trim($model->postalCode)) {
                                $address .= '<br>' . $model->postalCode;
                            }

                            if (trim($model->state)) {
                                $address .= '<br>' . $model->state;
                            }
                        }
                    }



                    echo $address;
                    ?>
                </td>
            </tr>
            
            <tr>
                <td style="width: 35%;color: #404040;text-align: right;">Telephone</td>
                <td style="text-align: right;"><?php echo $model->isThirdpartyDelivery ? $model->customerTelephone2 : $model->customerTelephone; ?></td>
            </tr>
            <tr>
                <td style="width: 35%;color: #404040;text-align: right;">Email</td>
                <td style="text-align: right;"><?php echo $model->isThirdpartyDelivery ? $model->contactEmail : $model->customerEmail; ?></td>
            </tr>

            <tr>
                <td style="width: 35%;color: #404040;text-align: right;">Contact Name</td>
                <td style="text-align: right;"><?php echo $model->isThirdpartyDelivery ? $model->contactPerson : $model->contactPerson1; ?></td>
            </tr>

        </table>

    </div>
    <div style="clear: both;"></div>
</div>



<table style="width: 100%;">

    <tr style="background-color: #ccc;width: 100%;">
        <th style="width: 10%;"></th>
        <th style="width: 50%;">Product</th>
        <th style="text-align: center;width: 15%;">Quantity</th>
        <th style="text-align: right;width: 25%;">Amount</th>

    </tr>   


</table>




<?php
$cart = WebstoreCart::model()->findByPk($model->webstoreCartId);
$cartdetails = WebstoreCartDetail::model()->findAll(array('condition' => "webstoreCartId =  $model->webstoreCartId", 'group' => "colorGroupCode,isBackOrder"));
$count = 0;
$totQty = 0;
$totAmount = 0;
foreach ($cartdetails as $dtl) {
    $count++;
    $product = ProductLine::model()->findByPk($dtl->productId);
    $code = $product->pdlpdl;
    $codeSplitted = explode(".", $code);
    $styleNo = $codeSplitted[0];
    $productColorName = substr($product->pdlprdline, 0, strrpos($product->pdlprdline, " "));
    $groupQty = $cart->getGroupQty($dtl->colorGroupCode,$dtl->isBackOrder);
    $groupAmount = $cart->getGroupAmount($dtl->colorGroupCode,$dtl->isBackOrder);
    //$totQty += $groupQty;
    //$totAmount += $groupAmount;
    ?>
    <table style="width: 100%;border-bottom: 1px solid #808080;">
        <tr style="width: 100%;">
            <td style="width: 10%;"><?php echo $count; ?></td>
            <td style="font-size: 1.2em;padding: 5px;width: 50%;">
                <img src="<?php echo $product->getImgForWebStore() ?: 'images\noimage.jpg'; ?>" style="max-height: 70px;max-width: 100px;float: left;"/>
                <div style="max-height: 70px;">
                    <?php echo $productColorName; ?><br>
                    <font style="font-size: 0.8em;font-weight: bold;">Colour Code : <?php echo $dtl->colorGroupCode; ?></font>
                    <?php
                    if ($dtl->isBackOrder) {
                        echo '<br><font style="font-size: 0.8em;font-weight: bold;color: seagreen;">This will be placed on back order</font>';
                    }
                    ?>
                </div>
            </td>
            <td style="font-size: 1.2em;padding: 5px;font-weight: bold;text-align: center;width: 15%;"><?php echo $groupQty; ?></td>
            <td style="font-size: 1.2em;padding: 5px;font-weight: bold;text-align: right;width: 25%;"><?php echo number_format($groupAmount, 2); ?></td>

        </tr>
        <tr style="border-bottom: solid 1px #808080;width: 100%;">
            <td></td>
            <td colspan="3">
                <?php
                echo $cart->getColorSizeQtyHtml($dtl->colorGroupCode,$dtl->isBackOrder);
                ?>
            </td>

        </tr>
    </table>

    <?php
}

$totalIncludingGst = $model->totalExGst * $model->gstRate;
$gstAmount = $totalIncludingGst - $model->totalExGst;
$gstPercentage = $model->gstRate ? (($model->gstRate * 100) - 100) : 0;
$location_freight = $model->postal_code_freight_charge;
$grandTotal = $totalIncludingGst + $location_freight;
?>
<table style="width: 100%;">
    <tfoot>
        <tr>
            <td></td>
            <td></td>
            <td style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;">Sub Total</td>
            <td id="tot-amount" style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;"><?php echo number_format($model->totalExGst, 2); ?></td>
            <td></td>
        </tr> 
        <tr>       
            <td></td>
            <td></td>
            <td style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;">GST ( <?php echo $gstPercentage; ?>% )</td>
            <td  id="tot-gst" style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;"><?php echo number_format($gstAmount, 2); ?></td>
            <td></td>
        </tr> 
        <tr>       
            <td></td>
            <td></td>
            <td style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;">Freight</td>
            <td  id="postal-location-freight" style="text-align: right;font-size: 1.2em;font-weight: bold;border-bottom: 1px solid #ccc;"><?php echo number_format($location_freight, 2); ?></td>
            <td></td>
        </tr> 
        <tr>                        
            <td colspan="3" style="text-align: right;font-size: 1.2em;font-weight: bold;">Total</td>
            <td  id="tot-gst" style="text-align: right;font-size: 1.2em;font-weight: bold;"><?php echo number_format($grandTotal, 2); ?></td>
            <td></td>
        </tr> 
    </tfoot>
</table>


<style>
    body { font-family: Arial, Helvetica, sans-serif; font-size: 8pt; }
</style>