<?php
$this->breadcrumbs = array(
    'Webstore Price Lists' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List WebstorePriceList', 'url'=>array('index')),
    array('label' => 'Create Web Store Price List', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('webstore-price-list-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Web Store Price Lists</h1>



<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none;max-height: ">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'webstore-price-list-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name'=>'webstore_search',
            'value'=>'WebStore::model()->findByPk($data->webstoreId)->name'
        ),
        'priceListName',
        'headerTxt',
        'comment',
        array(
            'name' => 'imageName',
            'type' => 'html',
            'value' => 'CHtml::image($data->getImg(), \'\', array(\'width\' => 100,\'max-height\' => 100))',
        ),
        array(
            'header'=>'File',
            'value'=>'is_file($data->getFile())?$data->fileName .  "<br> Size ( " . $data->format_size(filesize($data->getFile())) ."  )" : "N/A"',
            'type'=>'html'
        ),
        'createdDate',
        /*
          'fileName',
          'isActive',
          'createdDate',
          'createdBy',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep0}{delete}{sep}{download}',
            'buttons' => array
                (
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,                    
                ),
                'sep0' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstorePriceList/delete", array("id"=>$data->id))',
                ),
                'sep' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'download' => array
                    (
                    'label' => 'Download',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("webstorePriceList/downloadFile", array("id"=>$data->id))',
                ),
            ),
        ),
    ),
));
?>
