<?php
$this->breadcrumbs = array(
    'Webstore Price Lists' => array('index'),
    $model->id,
);

$this->menu = array(
    //array('label'=>'List WebstorePriceList', 'url'=>array('index')),
    array('label' => 'Create Web Store Price List', 'url' => array('create')),
    array('label' => 'Update Web Store Price List', 'url' => array('update', 'id' => $model->id)),
    array('label' => 'Delete Web Store Price List', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage Web Store Price List', 'url' => array('admin')),
);
?>

<h1>View Web Store Price List #<?php echo $model->id; ?></h1>

<?php
$filepath = $model->getFile();
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'id',
        array(
            'name' => 'webstoreId',
            'value' => $model->webstoreId ? WebStore::model()->findByPk($model->webstoreId)->name : ''
        ),
        'priceListName',
        'headerTxt',
        'comment',
        array(
            'name' => 'imageName',
            'type' => 'html',
            'value' => CHtml::image($model->getImg(), '', array('width' => 200, 'max-height' => 100)),
        ),
        array(
            'label' => 'File',
            'type' => 'raw',
            'value' => is_file($model->getFile())?$model->fileName . ' ( ' . $model->format_size(filesize($model->getFile())) . ' ) ' . CHtml::link('Download', 'index.php?r=webstorePriceList/downloadFile&id=' . $model->id, array('width' => 200, 'max-height' => 100, 'style'=>"cursor:pointer;")) : "N/A" ,
        ),
        array(
            'name' => 'isActive',
            'value' => $model->isActive ? 'YES' : 'NO',
        ),
        'createdDate',
        array(
            'name' => 'createdBy',
            'value' => $model->createdBy ? User::model()->findByPk($model->createdBy)->username : ''
        )
    ),
));
?>


