<?php
$this->breadcrumbs = array(
    'Webstore Users' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List WebstoreUser', 'url'=>array('index')),
    array('label' => 'Create Web Store Customer', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('webstore-user-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Web Store Customers</h1>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">

    <li class="active"><a href="#web-cus-sec" role="tab" data-toggle="tab" >Customers</a></li>

    <li><a href="#im-ex-sec" role="tab" data-toggle="tab" >Import Customers</a></li>

</ul>

<div class="tab-content">
    <div class="tab-pane active view" id="web-cus-sec" style="padding-top: 0;margin-top: 0;">
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'webstore-user-grid',
            'dataProvider' => $model->search(),
            'filter' => $model,
            'columns' => array(
                //'id',
                'username',
                //'password',
                'email',
                'companyName',
                //'is_active',
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{view}{sep1}{update}{sep2}{delete}',
                    'buttons' => array(
                        'view' => array
                            (
                            'label' => 'View',
                            'imageUrl' => false,
                        ),
                        'sep1' => array
                            (
                            'label' => ' | ',
                            'url' => '',
                            'imageUrl' => false,
                        ),
                        'update' => array
                            (
                            'label' => 'Update',
                            'imageUrl' => false,
                        ),
                        'sep2' => array
                            (
                            'label' => ' | ',
                            'url' => '',
                            'imageUrl' => false,
                        ),
                        'delete' => array
                            (
                            'label' => 'Delete',
                            'imageUrl' => false,
                        ),
                    )
                ),
            ),
        ));
        ?>
    </div>
    <div class="tab-pane view" id="im-ex-sec" style="padding-top: 0;margin-top: 0;">


        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'web-cus-import-form',
                    'enableAjaxValidation' => false,
                    'htmlOptions' => array('enctype' => 'multipart/form-data'),
                ));
                ?>

                <div class="row">
                    <?php echo $form->labelEx($model, 'webstore_user_store_id'); ?>
                    <?php
                    
                    //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
                    echo $form->dropDownList($model, 'webstore_user_store_id', CHtml::listData(WebStore::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array(
                        
                        'multiple' => true,                        
                            )
                    );
                    ?>
                    <?php echo $form->error($model, 'ws_user_id'); ?>
                    <div>[Ctrl + select] : To select multiple status options</div>
                </div>   

                <div class="row">
                    <?php echo $form->labelEx($model, 'importFile'); ?>
                    <?php echo $form->fileField($model, 'importFile', array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo $form->error($model, 'importFile'); ?>

                    <?php echo CHtml::submitButton('Upload File', array('name' => 'import_btn')); ?>
                    <div>[Only xls, xlsx file types are allowed] </div>
                </div>
                <div class="clear"></div>
                <?php
                //echo CHtml::submitButton('Reset', array('name' => 'reset_btn','style' => 'margin-left:5px;float:right;'));
                //echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>


<?php
if (!empty($logmessage)) {
    ?>

    <div class="view" >
        <h3><a href="#" onclick="showlogdtl();return false;">Import Log Details</a></h3>
        <div id="log-dtl-sec" style="display: none;">
            <?php
            if (!empty($logmessage['webstore_user_msg'])) {
                echo '<h4>Customer Import Log <h4>';
                echo '<pre>' . $logmessage['webstore_user_msg'] . '</pre>';
            }

            if (!empty($logmessage['customer_msg'])) {
                echo '<h4>MYOB Customer Issues <h4>';
                echo '<pre>' . $logmessage['customer_msg'] . '</pre>';
            }

            if (!empty($logmessage['webstore_user_error'])) {
                echo '<h4>MYOB Customer Errors <h4>';
                echo '<pre>' . $logmessage['webstore_user_error'] . '</pre>';
            }
            ?>
        </div>
    </div>

    <?php
}
?>

<script>



    function showlogdtl() {
        $('#log-dtl-sec').toggle();
    }
</script>
