

<?php
$this->menu = array(
    //array('label'=>'List WebstoreUser', 'url'=>array('index')),
    array('label' => 'Create', 'url' => array('create')),
    array('label' => 'Update', 'url' => array('update', 'id' => $model->id)),
    array('label' => 'Delete', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage', 'url' => array('admin')),
);
?>

<h1>View Web Store Customer #<?php echo $model->id; ?></h1>
<input type="hidden" id="webcusid" value="<?php echo $model->id; ?>" >
<?php
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'id',
        'username',
        array(
            'name' => 'password',
            'value' => '*******************'
        ),
        'email',
        array(
            'name' => 'customer_id',
            'value' => Customer::model()->findByPk($model->customer_id)->cusnam
        ),
        'companyName',
        'is_active',
        'budget_enabled'
    ),
));
?>

<div class="clear"></div>


<h3>Customer Web Stores</h3>
<div class="view">
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'webstore-user-store-grid',
        'dataProvider' => $userstore->search(),
        'filter' => null,
        'columns' => array(
            'id',
            //'web_user_id',
            array(
                'name' => 'webstore_id',
                'value' => 'WebStore::model()->findByPk($data->webstore_id)->name'
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array(
                        'label' => 'Revoke',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("webstoreUserStore/delete", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));

    echo CHtml::button('Allocate Stores', array('name' => 'allocate-cus-webstr-btn', 'onclick' => 'selectWebstore();'));
    ?>




</div>

<h3>Customer Budgets</h3>
<div class="view">
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'webstore-user-budget-grid',
        'dataProvider' => $websroreUserBudgets->search(),
        'filter' => $websroreUserBudgets,
        'columns' => array(
            'id',
            //'webstore_user_id',
            'name',
            'amount',
            'date_start',
            'date_end',
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array(
                        'label' => 'Revoke',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("webstoreUserBudget/delete", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));


    echo CHtml::button('Add Budget', array('name' => 'add-budget-to-webcus', 'onclick' => 'addNewBudget();'));
    ?>




</div>
<!-- Add web stores from grid -->
<div id="allocate-webstore-cus-model" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">

                <h3 style="text-align: center;">Allocate Web Stores</h3>
            </div>
            <div class="modal-body">
                <?php
                $this->renderPartial('/webStore/_admin', array('model' => $websrore));
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="addWebstoresFromGrid();">Add</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>
<!-- add budgets for web customer -->
<div  id="add-webcus-budget" class="modal fade modal-dialog" role="dialog">

    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">

            <h3 style="text-align: center;">Add Budgets</h3>
        </div>
        <div class="modal-body">
            <?php
            $websroreUserBudgets->webstore_user_id = $model->id;
            $this->renderPartial('/webstoreUserBudget/_form_inc', array('model' => $websroreUserBudgets));
            ?>


        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="saveBudget();">Add</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
    </div>

</div>
<script>

    function selectWebstore() {
        showcentermodel('allocate-webstore-cus-model');
    }

    function addWebstoresFromGrid() {
        let webstoreIds = new Array();
        $.each($("input[name='web-store-grid_c0[]']:checked"), function () {
            webstoreIds.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        if (webstoreIds.length > 0) {
            addWebstoresToWebCustomer(webstoreIds);
        }


    }


    function addWebstoresToWebCustomer(webstoreIds) {

        $.ajax({
            url: '<?php echo Yii::app()->createUrl("webstoreUser/addWebstores"); ?>',
            type: 'POST',
            data: {'webcusid': $('#webcusid').val(), 'webstoreIds': webstoreIds},
            datatype: 'json',
            success: function (result) {
                $.fn.yiiGridView.update('webstore-user-store-grid');


            },
            error: function (data) {

            }
        });

        return false;
    }

    /**
     * Add new budget
     * */

    function addNewBudget() {
        showcentermodel('add-webcus-budget');
    }

    function saveBudget() {
        
        var fd = new FormData($("#webstore-user-budget-form")[0]);
        //var e = document.getElementById("subrowimage");
        //fd.append("Workorderdetails[image]", $(e)[0].files[0]);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("webstoreUserBudget/createBudget"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function () {
                // do some loading options
            },
            success: function (result) {
                 $.fn.yiiGridView.update('webstore-user-budget-grid');

            },
            complete: function () {
                // success alerts
            },
            error: function (data) {
               

            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }


    function showcentermodel(id) {
        $("#" + id).modal('show').css(
                {
                    'margin-top': function () {
                        return -($(this).height() / 2);
                    },
                    'margin-left': function () {
                        return -($(this).width() / 2);
                    },
                })
    }

    function hide(callID, hideID) {
        if ($('#' + hideID).is(":visible")) {
            $('#' + hideID).slideUp(500);
            $('#' + callID).attr("src", 'images/more_details.png');


        } else {
            $('#' + hideID).slideDown(500);
            $('#' + callID).attr("src", 'images/less_details.png');


        }
    }
</script>