<?php
$this->breadcrumbs = array(
	'Workorders' => array('index'),
	'Manage',
);

$jobinfocusmenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
	$jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}
$this->menu = array(
	$jobinfocusmenu,
		//array('label'=>'List Workorder', 'url'=>array('index')),
		//array('label'=>'Create Workorder', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('workorder-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>
    Manage Sales Orders&nbsp;
	<?php
	if (isset($_GET['newso']) && $_GET['newso'] == 1)
		echo '[ NEW ]';
	?>
</h1>

<div >
	<?php
	foreach (Yii::app()->user->getFlashes() as $key => $message) {
		echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
	}
	?>
</div>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

	<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
	<?php
	$this->renderPartial('_search', array(
		'model' => $model,
	));
	?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id' => 'workorder-grid',
	'dataProvider' => $model->search(),
	'filter' => $model,
	'columns' => array(
		//'id',
		//'quotationId',
		array(
			'header' => 'No.',
			'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
		),
		array(
			'name' => 'createddate',
			'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createddate))'
		),
		array(
			'name' => 'salesorderNumber',
			'value' => '$data->getSONumberWithJobLink() . $data->getCancelStatusText()',
			'htmlOptions' => array('style' => 'width:120px;'),
			'type' => 'raw',
		),
		array(
			'name' => 'quotationNumber',
			'value' => 'CHtml::link($data->quotationNumber,array("quatation/view","id"=>$data->quotationId))',
			'type' => 'raw',
		),
		array(
			'name' => 'mastercus_search',
			'value' => '$data->getMasterCustomerLink()',
			'filter' => CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
			'type' => 'raw',
		),
//        array(
//            'name' => 'quotation.customer.cusmcussno',
//            'value' => '$data->quotation->getMasterCustomerLink()',
//            'type'=>'raw',
//        ),
//        array(
//            'name'=>'quotation.customer.cusnam',
//            'value'=>'$data->quotation->getCustomerLink()',
//            'type'=>'raw',
//        ),
		array(
			'name' => 'customer_search',
			'value' => '$data->getCustomerLink()',
			'type' => 'raw',
		),
//        array(
//            'name'=>'quoteComment_search',
//            'value'=>'$data->quotation->quotecomments',
//            'htmlOptions'=>array('style'=>'width:150px;')
//        ),
		array(
			'name' => 'coordinator_search',
			'value' => '$data->coordinator->username',
		//'htmlOptions'=>array('style'=>'width:150px;')
		),
		array(
			'name' => 'salesperson_search',
			'value' => '$data->salesperson->name',
		//'htmlOptions'=>array('style'=>'width:150px;')
		),
		//'ws_user',
//        array(
//            'name'=>'status_id',  
//            'value'=>'$data->status->name',
//            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,2,6,3)",'order'=>'name asc')), 'id', 'name'),
//        ),
		array(
			'name' => 'followupStatus',
			'value' => '$data->getFollowupStatus()',
			'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'SalesOrder'", 'order' => 'status ASC')), 'id', 'status'),
		// 'type' => 'raw',
		),
		array(
			'name' => 'onlineQuoteAcceptanceStatusSearch',
			'value' => '$data->onlineAcceptenceLog ? $data->onlineAcceptenceLog->toString() : ""',
			'filter' => CHtml::dropDownList('Workorder[onlineQuoteAcceptanceStatusSearch]', 
					$model->onlineQuoteAcceptanceStatusSearch, 
					WorkorderOnlineAcceptenceLog::LOG_STATUS_ARRAY, 
					array('empty' => '-- SELECT STATUS --')
			),
		),
		array(
			'class' => 'CButtonColumn',
			'template' => '{view}{sep1}{confirm}{sep2}{convrtojob}{sep3}{cancel}{sep4}{print}',
			'buttons' => array(
				'view' => array
					(
					'label' => 'View',
					'imageUrl' => false,
					'url' => 'Yii::app()->createUrl("workorderdetails/admin", array("wid"=>$data->id))',
				),
				'sep1' => array
					(
					'label' => ' | ',
					'url' => '',
					'imageUrl' => false,
				),
				'confirm' => array
					(
					'label' => 'Confirm',
					'imageUrl' => false,
					'url' => 'Yii::app()->createUrl("workorder/confirm", array("id"=>$data->id))',
					'visible' => '$data->allowtocomfirm()',
				),
				'sep2' => array
					(
					'label' => ' | ',
					'url' => '',
					'imageUrl' => false,
					'visible' => '$data->allowtocomfirm()',
				),
				'convrtojob' => array
					(
					'label' => 'Convert To Job',
					'imageUrl' => false,
					'url' => 'Yii::app()->createUrl("workorder/converttoJob", array("id"=>$data->id))',
					'visible' => 'in_array($data->status_id,array(2))',
				),
				'sep3' => array
					(
					'label' => ' | ',
					'url' => '',
					'imageUrl' => false,
					'visible' => 'in_array($data->status_id,array(2))',
				),
				'cancel' => array
					(
					'label' => 'Cancel',
					'imageUrl' => false,
					'url' => 'Yii::app()->createUrl("workorder/cancel", array("id"=>$data->id))',
					'visible' => '!in_array($data->status_id,array(3))',
				),
				'sep4' => array
					(
					'label' => ' | ',
					'url' => '',
					'imageUrl' => false,
				),
				'print' => array
					(
					'label' => 'Print PDF',
					'imageUrl' => false,
					'url' => 'Yii::app()->createUrl("workorder/print", array("id"=>$data->id))',
					'options' => array('target' => '_blank'),
				),
			),
		),
	),
));
?>
