<?php


Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('workorder-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<h1>All Pending Confirmations</h1>

<div >
    <?php 
        foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
        }
    ?>
</div>

<h3>Sales Orders</h3>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'workorder-grid',
    'dataProvider' => $model->search(),  
    'filter' => null,
    'columns' => array(
        //'id',
        //'quotationId',
         array(
        'header'=>'No.',
        'value'=>'$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
      ),
        
        array(
            'name'=>'createddate',
            'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->createddate))'
        ),
        array(
        'name'=>'salesorderNumber',
        //'value'=>'$data->salesorderNumber',
      ),
         array(
            'name'=>'quotationNumber',
            'value'=>'$data->quotationNumber',
            'type'=>'raw',
        ),  
        array(
            'name' => 'mastercus_search',
            'value' => '!empty($data->master) ? $data->master->mcusnam : "Not Set"',
            //'filter'=>CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type'=>'raw',
        ),
        
//        array(
//            'name' => 'quotation.customer.cusmcussno',
//            'value' => '$data->quotation->getMasterCustomerLink()',
//            'type'=>'raw',
//        ),
//        array(
//            'name'=>'quotation.customer.cusnam',
//            'value'=>'$data->quotation->getCustomerLink()',
//            'type'=>'raw',
//        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->customer->cusnam',
            'type'=>'raw',
            ),
        'quotation.quotecomments',
        'ws_user',
        array(
            'name'=>'status_id',  
            'value'=>'$data->status->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,2,6,3)",'order'=>'name asc')), 'id', 'name'),
        ),
              
        
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}',
            'buttons' => array(
                
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("workorderdetails/cusView", array("id"=>$data->id))',
                ),                
            ),
        ),
    ),
));
?>


<h3>Artwork Jobs</h3>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'job-artwork-grid',
    'dataProvider' => $dataproviderArtworkJob,
    'filter' => null,
    'columns' => array(
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->dueDate))',
        ),
        array(
            'name' => 'archiveImageLogo',
            'value' => 'CHtml::image("images/artwork/job/" . $data->artworkjobNum . "/" . $data->archiveImageLogo, "", array("style" => "width:150px;"))',
            'type' => 'raw',
        ),
        'artworkjobNum',
        //'productColor',		
        //'decorationType',
        'logoName',
        //'printSize',
        //'printColor',
        'designNumber',
        //'isRepeatDesign',
        'comments',
        //'signOffTerms',
        'jobType',
        array(
            'name' => 'job_status_id',
            'value' => 'Status::getStatusName($data->job_status_id)',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (5,17,18)")), 'id', 'name'),
        ),
        array(
            'name' => 'approve_status_id',
            'value' => 'Status::getStatusName($data->approve_status_id)',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (22,23)")), 'id', 'name'),
        ),
//        array(
//            'name' => 'approveDate',
//            'value' => '(!empty($data->approveDate) ? date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->approveDate)) : "Not Set")',
//        ),
        array(
            'name' => 'createdDate',
            'value' => 'date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->createdDate))',
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                     'url' => 'Yii::app()->createUrl("jobArtwork/cusView", array("id"=>$data->id))',
                ),
                
            ),
        ),
    ),
));
?>
