<?php




Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");


?>

<h1>Sales Order Status Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>
        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'followupStatus'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['so_sts_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['so_sts_selcted']);
                foreach ($stsArr as $key=>$val){
                    $optionsselected[$val] = array('selected'=>true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'followupStatus', 
                    CHtml::listData(FollowupStatus::model()->findAll(array('condition'=>"type = 'SalesOrder'", 'order'=>'status')), 'id', 'status'), 
                    array('empty' => '',
                        'multiple'=>true,
                            'options'=>$optionsselected
                        )
                    );
            ?>
            <?php echo $form->error($model, 'followupStatus'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        
        
        <div class="clear"></div>
        <div>
            <?php 
            echo CHtml::submitButton('Go',array('name'=>'go_btn'));
            echo CHtml::submitButton('Reset',array('name'=>'reset_btn'));
            $this->endWidget();
           
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'purchase-orders-form',
                'enableAjaxValidation' => false,
                'action'=>Yii::app()->createUrl('//jobs/dueExportExcel'),
                'htmlOptions'=>array('style'=>'display:inline;')
            ));
            
            
            //echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); 
            //echo CHtml::button('Generate Excel', array('style' => 'float:right;', 'onclick' => 'generateExcel();')); 
        
        
            //echo CHtml::submitButton('Export to Excel', array( 'style' => 'margin-left:5px;float:right;'));
            //echo CHtml::button('Print PDF', array('onclick' => "printPDF();", 'style' => 'margin-left:5px;float:right;'));
            $this->endWidget();
            
            
            ?>
        </div>
        
    </div>
    <div class="clear"></div>
</div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'workorder-grid',
    'dataProvider' => $model->searchStatus(),
    'filter' => $model,
    'columns' => array(
        //'id',
        //'quotationId',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'createddate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createddate))',
            'filter'=>false,
        ),
        array(
            'name' => 'salesorderNumber',
            'value' => '$data->getSONumberWithJobLink()',
            'htmlOptions' => array('style' => 'width:120px;'),
            'type' => 'raw',
        ),
        array(
            'name' => 'quotationNumber',
            'value' => 'CHtml::link($data->quotationNumber,array("quatation/view","id"=>$data->quotationId))',
            'type' => 'raw',
        ),
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            //'filter' => CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type' => 'raw',
        ),
//        array(
//            'name' => 'quotation.customer.cusmcussno',
//            'value' => '$data->quotation->getMasterCustomerLink()',
//            'type'=>'raw',
//        ),
//        array(
//            'name'=>'quotation.customer.cusnam',
//            'value'=>'$data->quotation->getCustomerLink()',
//            'type'=>'raw',
//        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'quoteComment_search',
            'value' => '$data->quotation->quotecomments',
            'htmlOptions' => array('style' => 'width:150px;')
        ),
        array(
            'name' => 'salesperson_search',
            'value' => '$data->salesperson->name',
            'type' => 'raw',
        ),
//        array(
//            'name'=>'status_id',  
//            'value'=>'$data->status->name',
//            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,2,6,3)",'order'=>'name asc')), 'id', 'name'),
//        ),
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            //'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'SalesOrder'", 'order' => 'status ASC')), 'id', 'status'),
            'filter'=>false,
        // 'type' => 'raw',
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("workorderdetails/admin", array("wid"=>$data->id))',
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),                
                'print' => array
                    (
                    'label' => 'Print PDF',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("workorder/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            ),
        ),
    ),
));
?>
<script>
//    function printPDF() {
//        //alert(status_id);
//        var win = window.open('index.php?r=jobs/printDue');
//    }
    
    function generateExcel() {
        var win = window.open('index.php?r=quatation/generateStatusExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=quatation/generateStatusPDF');

    }


</script>