<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script language="javascript" type="text/javascript">
    /**
     * detect customisation detail spec change and load into customisation details
     * 
     */
    $(document).on('change', '.spec_list', function() {

        const specId = $(this).val();
        const rawId = $(this).attr('rawId');

        loadCustomisationSpec(specId, rawId);

    });


    function loadCustomisationSpec(specId, workorderDetailID) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("customisationDetailSpecification/fetchSpec"); ?>',
            data: {
                id: specId
            },
            dataType: 'json',
            success: function(result) {
                $(`#customisation_details_${workorderDetailID}`).val((result.spec ? result.spec : ''));
                $(`#customisation_details_${workorderDetailID}`).trigger("change");
            },
            error: function(result) {
                console.log(result);
            }
        });
    }

    /*
     * popup line options functionality
     * peform on _quote_detail_row_html.php also
     **/

    $(document).on('click', '.lineOptionRow', function() {

        showLineFlagSettings($(this).attr('lineOptionRowId'));
    });

    function showLineFlagSettings(id) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/fetchDetailFlags"); ?>',
            data: {
                id: id
            },
            dataType: 'json',
            success: function(result) {


                var options = {};
                options.selected = result.flags;

                options.inputOptions = [{
                    text: 'Hide on PDF',
                    value: 'hide_on_pdf',
                }, ];

                bootbox.prompt({
                    title: "Line Options",
                    value: options.selected,
                    inputType: 'checkbox',
                    inputOptions: options.inputOptions,
                    callback: function(result) {
                        if (result) {
                            var obj = {};
                            obj.id = id;
                            obj.flags = result;

                            //if no flag has been selected  then 'flags' array will be empty, so we need to add the flag attributes manually to the object to turn them off
                            if (!obj.flags.length) {
                                obj.offFlags = ['hide_on_pdf'];
                            }
                            updateLineOptionFlags(obj);
                        }
                    }
                });


            },
            error: function(result) {
                console.log(result);
            }
        });



    }

    function updateLineOptionFlags(obj) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateDetailFlags"); ?>',
            data: obj,
            dataType: 'json',
            success: function(result) {

                if (result.success) {
                    refreshLineOptionsFlagsLabels(obj);
                }
            },
            error: function(result) {
                console.log(result);
            }
        });
    }


    function refreshLineOptionsFlagsLabels(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/onFlagsLabelsHtml"); ?>',
            data: obj,
            dataType: 'json',
            success: function(result) {

                $('#flagLabelTextDiv_' + obj.id).empty();
                $('#flagLabelTextDiv_' + obj.id).html(result.html);

            },
            error: function(result) {
                console.log(result);
            }
        });
    }

    var GST = null;
    var sizeoptionhtml = null;
    var toDeleteWrkorderDtl = [];

    $(document).on('change', '.so-line-select', function() {

        const workorder_details_id = $(this).attr('detail-id');

        if ($('#delete_row_' + workorder_details_id).is(':checked')) {
            toDeleteWrkorderDtl.push(workorder_details_id);
        } else {
            var removeItem = workorder_details_id;

            toDeleteWrkorderDtl = jQuery.grep(toDeleteWrkorderDtl, function(value) {
                return value != removeItem;
            });
        }

        if (toDeleteWrkorderDtl.length > 0) {
            toggleDetailOptionButtons(false);
        } else {
            toggleDetailOptionButtons(true);
        }
    });

    function toggleDetailOptionButtons(doDisable) {

        jQuery("#delete_workorder_dtl_all").prop('disabled', doDisable);
        jQuery("#quote-copy-line-btn").prop('disabled', doDisable);

    }



    function deleteSelectedDtls() {
        deleteMultipleRecords(toDeleteWrkorderDtl);
    }

    function copySelectedLines() {

        callCopyLines(toDeleteWrkorderDtl);
    }

    function callCopyLines(selectedDetailIds) {

        $.ajax({
            url: '<?php echo Yii::app()->createUrl("workorder/copyLine"); ?>',
            type: 'POST',
            data: {
                'workorderId': $('#modelId').val(),
                workorderDetalIdStr: selectedDetailIds + ''
            },
            datatype: 'json',

            success: function(result) {
                var obj = jQuery.parseJSON(result);
                $.each(obj, function(index, rowhtml) {
                    addmainrow(rowhtml);
                });
            },
            error: function(data) {

            }
        });
    }






    function changessaved(id) {
        $('#savemessage_' + id).empty();
        $('#savemessage_' + id).css('color', '#00ff00');
        $('#savemessage_' + id).html('Changes are saved');
        $('#savemessage_' + id).fadeIn(500).fadeOut(1500);

    }

    function saveworkdetails(wrkodrID) {
        /*
         $.ajax({
         type: 'POST',
         url: '<?php echo Yii::app()->createUrl("workorder/saveWorkorderDetails"); ?>',
         data: {'id': wrkodrID},
         dataType: 'json',
         success: function(result) {
         
         },
         error: function(result) {
         alert('error in save all workorder details');
         }
         });
         */
        $('#wrkorder-chnges-msg').fadeIn(1500).fadeOut(1500);

    }




    function checkQtyDiff(wrkodrdtlID) {

        /*
         $.ajax({
         type: 'POST',
         url: 'workorderdetails/ajaxQtyDiff',
         data: {'id': wrkodrdtlID},
         dataType: 'json',
         success: function (result) {
         var qtydiff = parseInt(result.qtydiff, 10);
         
         if (qtydiff > 0) {
         $('#savemessage_' + wrkodrdtlID).hide();
         $('#savemessage_' + wrkodrdtlID).empty();
         $('#savemessage_' + wrkodrdtlID).css('color', '#ff0000');
         $('#savemessage_' + wrkodrdtlID).html('There is a quantity mismatch (difference: ' + result.qtydiff + ')');
         $('#savemessage_' + wrkodrdtlID).fadeIn(500);
         
         $('#main_itmqty_mismatch_msg').empty();
         $('#main_itmqty_mismatch_msg').append('<font style="color:#ff0000;font-size:1.2em;font-weight:bold;">Item quantities not matched with the size breaking quantities</font>');
         
         } else {
         $('#savemessage_' + wrkodrdtlID).hide();
         checkFullQtyDiff(result.workorderID);
         }
         
         },
         error: function (result) {
         
         }
         });
         */
    }

    function checkFullQtyDiff(workorderID) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("Workorder/fullQtyDiff"); ?>',
            data: {
                'id': workorderID
            },
            dataType: 'json',
            success: function(result) {

                if (result.isQtyDiff == false) {
                    $('#main_itmqty_mismatch_msg').empty();
                }

            },
            error: function(result) {

            }
        });
    }


    function saveLineOrder(id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/saveLineOrder"); ?>',
            data: {
                'wrkorddtlID': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(id);
                }
            },
            error: function(result) {

            }
        });
    }


    function savecustmdeco(id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateCustomDecoration"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {

                if (result.status === 'success') {
                    changessaved(id);
                }
            },
            error: function(result) {

            }
        });
    }


    function savecustomprod(id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateCustomProduct"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {

                if (result.status === 'success') {
                    changessaved(id);
                }
            },
            error: function(result) {

            }
        });
    }

    function savedecoration(wrkoId, decsno, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateDecorationName"); ?>',
            data: {
                'wrkorddtlID': wrkoId,
                'value': value
            },
            dataType: 'json',
            success: function(result) {

                if (result.status === 'success') {

                    changessaved(wrkoId);
                }
            },
            error: function(result) {

            }
        });
    }

    function saveprodlngdes(wrkoId, pdlsno, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateProductLongDescription"); ?>',
            data: {
                'wrkorddtlID': wrkoId,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(wrkoId);
                }
            },
            error: function(result) {

            }
        });
    }

    function saveproductsku(wrkorddtlID, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateProductShortDescription"); ?>',
            data: {
                'wrkorddtlID': wrkorddtlID,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(wrkoId);
                }
            },
            error: function(result) {

            }
        });
    }




    function saveprodcutqty(id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateProductQty"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    validateQtyMismatch({
                        workorderdetailsID: id
                    });
                }
            },
            error: function(result) {

            }
        });


    }


    function savedecorateqty(id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateDecorateQty"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(id);
                }
            },
            error: function(result) {

            }
        });

        //fireTotal(id);
    }




    var visibledSizeQtyColorRowID = [];

    function visiblesizeqtycolorDBTable(id) {

        if ($('#sizeqtycolorDB_tbl_container_' + id).is(":visible")) {
            $('#sizeqtycolorDB_tbl_container_' + id).slideUp(300);
            $('#viewsizecolor_' + id).empty();
            $('#viewsizecolor_' + id).html('View Size/Colors');
        } else {
            $('#sizeqtycolorDB_tbl_container_' + id).slideDown(300);
            $('#viewsizecolor_' + id).empty();
            $('#viewsizecolor_' + id).html('Hide Size/Colors');
        }

        /*
         if (jQuery.inArray(id, visibledSizeQtyColorRowID) != -1) {
         visibledSizeQtyColorRowID = jQuery.grep(visibledSizeQtyColorRowID, function(value) {
         return value != id;
         });
         
         $('#sizeqtycolorDB_tbl_container_' + id).slideUp(300);
         } else {
         visibledSizeQtyColorRowID.push(id);
         $('#sizeqtycolorDB_tbl_container_' + id).slideDown(300);
         }
         */

    }



    function savecutomizeddetails(id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateCustomizedDetails"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(id);
                }
            },
            error: function(result) {

            }
        });
    }

    function savenotes(id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/updateNotes"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(id);
                }
            },
            error: function(result) {

            }
        });
    }


    function savesize(workorderdetailID, id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetailssizecolor/updateSize"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(workorderdetailID);
                    validateQtyMismatch({
                        workorderdetailsID: workorderdetailID
                    });
                }
            },
            error: function(result) {

            }
        });
    }

    function saveqty(workorderdetailID, id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetailssizecolor/updateQty"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(workorderdetailID);

                    validateQtyMismatch({
                        workorderdetailsID: workorderdetailID
                    });
                }
            },
            error: function(result) {

            }
        });
    }

    function savecolor(workorderdetailID, id, value) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetailssizecolor/updateColor"); ?>',
            data: {
                'id': id,
                'value': value
            },
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    changessaved(workorderdetailID);
                    validateQtyMismatch({
                        workorderdetailsID: workorderdetailID
                    });
                }
            },
            error: function(result) {

            }
        });
    }



    function addsizeqtycolorDBrow(id, prevRawID) {
        var prevsize = '';
        var prevqty = '';
        var prevcolor = '';
        if (prevRawID > 0) {

            prevsize = $('#sizecombo_' + prevRawID).val();
            prevqty = $('#sizeqtyrow_' + prevRawID).val();
            prevcolor = $('#color_' + prevRawID).val();

        }


        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetailssizecolor/createRecordAjax"); ?>',
            data: {
                'id': id,
                'copysize': prevsize,
                'copyqty': prevqty,
                'copycolor': prevcolor
            },
            dataType: 'json',
            success: function(result) {
                if (result.rowid > 0) {
                    createSizeQtyColorDBrow(id, result.rowid, prevRawID);
                    $('#sizeQtyClrSaveChangesBtn_' + id).show();
                    validateQtyMismatch({
                        workorderdetailsID: workorderdetailsID
                    });
                }
            },
            error: function(result) {

            }
        });


    }


    function validateQtyExceed(wororderdetailsID, sizeqtyrowID, value) {

        /*
         var prodQty = $('#prodqty_' + wororderdetailsID).val();
         var totalQty = 0;
         var inputQty = value;
         
         var balanceQty = 0;
         
         jQuery('#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr').not(':first').children('td:nth-child(3)').each(function () {
         
         if ($.isNumeric(jQuery(this).html())) {
         totalQty += parseInt(jQuery(this).html());
         }
         });
         
         
         jQuery('#sizeqtycolorDB_tbl_' + wororderdetailsID + ' input[name="qty"]').each(function () {
         if ($.isNumeric(jQuery(this).val())) {
         totalQty += parseInt(jQuery(this).val());
         }
         });
         
         balanceQty = prodQty - (totalQty - value);
         
         if (balanceQty < inputQty) {
         $('#sizeqtyrow_' + sizeqtyrowID).val(balanceQty);
         $('#sizeqtyrow_' + sizeqtyrowID).trigger("change");
         }
         */


    }

    function isQtyExceed(wororderdetailsID) {

        /*
         var prodQty = $('#prodqty_' + wororderdetailsID).val();
         var totalQty = 0;
         
         
         var balanceQty = 0;
         
         jQuery('#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr').not(':first').children('td:nth-child(3)').each(function () {
         
         if ($.isNumeric(jQuery(this).html())) {
         totalQty += parseInt(jQuery(this).html());
         }
         });
         
         
         jQuery('#sizeqtycolorDB_tbl_' + wororderdetailsID + ' input[name="qty"]').each(function () {
         if ($.isNumeric(jQuery(this).val())) {
         totalQty += parseInt(jQuery(this).val());
         }
         });
         
         balanceQty = prodQty - totalQty;
         
         if (balanceQty > 0)
         return false;
         else if (balanceQty < 0 || balanceQty === 0)
         return true;
         */


    }

    function validateQtyMismatch(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("Workorderdetailssizecolor/validateQtyMismatch"); ?>',
            data: obj,
            dataType: 'json',
            success: function(result) {

                $('#sizeQtyClrSaveChangesBtn_' + obj.workorderdetailsID).show();

                if (result.message === 'DECEED' || result.message === 'EXCEEDED') {
                    $('#savemessage_' + obj.workorderdetailsID).hide();
                    $('#savemessage_' + obj.workorderdetailsID).empty();
                    $('#savemessage_' + obj.workorderdetailsID).css('color', '#FF9B3B');
                    //$('#savemessage_' + obj.workorderdetailsID).html('There is a quantity mismatch (' + result.message + ': ' + result.balance + ')');
                    $('#savemessage_' + obj.workorderdetailsID).html(`Note: Quantity mismatch of ${result.balance} units between line total and size grid total`);
                    $('#savemessage_' + obj.workorderdetailsID).fadeIn(500);

                    $('#main_itmqty_mismatch_msg').empty();
                    $('#main_itmqty_mismatch_msg').append('<font style="color:#FF9B3B;font-size:1.2em;font-weight:bold;">Item quantities not matched with the size breaking quantities</font>');

                } else {
                    $('#savemessage_' + obj.workorderdetailsID).hide();
                    $('#main_itmqty_mismatch_msg').empty();

                }


            },
            error: function(result) {

            }
        });
    }

    function inserttabrow(evt, wrkodrID, prevRawID) {
        //evt.preventDefault();

        // if (isQtyExceed(wrkodrID) === false) {
        var code = evt.keyCode || evt.which;

        if (code == '9') {
            //if (confirm("Are you sure to insert another size quantity row?")) {
            addsizeqtycolorDBrow(wrkodrID, prevRawID);
            //}
        }
        //}


    }


    function createSizeQtyColorDBrow(wororderdetailsID, sizeqtycolorrowID, prevRawID) {


        var rowCount = $('#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr').length;

        var prevsize = '';
        var prevqty = '';
        var prevcolor = '';
        if (prevRawID > 0) {

            prevsize = $('#sizeqtycolorDB_tbl_' + wororderdetailsID).closest('tr').find('tr:last select').val();
            if (!prevsize) {
                prevsize = $('#sizecombo_' + prevRawID).val();
            }
            prevqty = $('#sizeqtyrow_' + prevRawID).val();
            prevcolor = $('#color_' + prevRawID).val();
        }


        var html = '<tr id="sizeqtycolorDBrow_' + sizeqtycolorrowID + '">\n\
                        <td>' + rowCount + '</td>\n\
                        <td>' + getSizeList(wororderdetailsID, sizeqtycolorrowID, prevsize) + '</td>\n\
                        <td><input onkeyup="validateQtyExceed(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" onchange="saveqty(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" type="text" value="' + prevqty + '" name="qty" id="sizeqtyrow_' + sizeqtycolorrowID + '"/></td>\n\
                        <td><input onkeydown="inserttabrow(event,' + wororderdetailsID + ',' + sizeqtycolorrowID + ');" onchange="savecolor(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" type="text" value="' + prevcolor + '" name="color" id="color_' + sizeqtycolorrowID + '"/></td>\n\
                        <td>\n\
                            <a href="#" onclick="editsizeqtycolorDBrowAjaxcall(' + sizeqtycolorrowID + ');return false;">Edit</a>&nbsp;|&nbsp;\n\
                             <a href="#" onclick="deletesizeqtycolorDBrow(' + sizeqtycolorrowID + ');return false;">Delete</a></td>\n\
                        </tr>';
        //<input onchange="savesize(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);"  type="text" value="' + prevsize + '" name="size" id="size_' + sizeqtycolorrowID + '"/>                    
        $('#sizeqtycolorDB_tbl_' + wororderdetailsID).append(html);
        $('#sizecombo_' + sizeqtycolorrowID).focus();

        $('#sizecombo_' + sizeqtycolorrowID).val(prevsize);
        $('#sizecombooption_' + sizeqtycolorrowID + ' option[value=\'' + prevsize + '\']').attr('selected', 'selected');

        savesize(wororderdetailsID, sizeqtycolorrowID, prevsize);
        saveqty(wororderdetailsID, sizeqtycolorrowID, prevqty);
        savecolor(wororderdetailsID, sizeqtycolorrowID, prevcolor);
    }

    //edit size qty color row
    function editsizeqtycolorDBrowAjaxcall(sizeqtycoloRowID) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("Workorderdetailssizecolor/getWorkorderDetailID"); ?>',
            data: {
                'id': sizeqtycoloRowID
            },
            dataType: 'json',
            success: function(result) {

                var sizeQtyColr = [];
                sizeQtyColr['size'] = result.size;
                sizeQtyColr['qty'] = result.qty;
                sizeQtyColr['color'] = result.color;
                editsizeqtycolorDBrow(result.wodtlID, sizeqtycoloRowID, result.prevRawID, sizeQtyColr);
                $('#sizeQtyClrSaveChangesBtn_' + result.wodtlID).show();


            },
            error: function(result) {

            }
        });
    }

    function editsizeqtycolorDBrow(wororderdetailsID, sizeqtycolorrowID, prevRawID, sizeQtyColr) {
        var size = 0;
        var qty = 0;
        var color = '';




        size = sizeQtyColr['size'];
        qty = sizeQtyColr['qty'];
        color = sizeQtyColr['color'];






        var rowCount = $('#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr').length;

        var prevsize = '';
        var prevqty = '';
        var prevcolor = '';
        if (prevRawID > 0) {
            prevsize = $('#size_' + prevRawID).val();
            prevqty = $('#sizeqtyrow_' + prevRawID).val();
            prevcolor = $('#color_' + prevRawID).val();
        }

        //edit size input
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(2)').empty();
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(2)').html(getSizeList(wororderdetailsID, sizeqtycolorrowID, size));
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(2) #sizecombo_' + sizeqtycolorrowID).val(size);
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(2) #sizecombooption_' + sizeqtycolorrowID + ' option[value=\'' + size + '\']').attr('selected', 'selected');

        //edit qty input
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(3)').empty();
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(3)').html('<input onkeyup="validateQtyExceed(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" onchange="saveqty(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" type="text" value="' + qty + '" name="qty" id="sizeqtyrow_' + sizeqtycolorrowID + '"/>');

        //edit color input
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(4)').empty();
        $('table#sizeqtycolorDB_tbl_' + wororderdetailsID + ' tr#sizeqtycolorDBrow_' + sizeqtycolorrowID + ' td:nth-child(4)').html('<input onkeydown="inserttabrow(event,' + wororderdetailsID + ',' + sizeqtycolorrowID + ');" onchange="savecolor(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" type="text" value="' + color + '" name="color" id="color_' + sizeqtycolorrowID + '"/>');

        /*
         var html = '<tr id="sizeqtycolorDBrow_' + sizeqtycolorrowID + '">\n\
         <td>' + rowCount + '</td>\n\
         <td>' + getSizeList(wororderdetailsID, sizeqtycolorrowID, size) + '</td>\n\
         <td><input onkeyup="validateQtyExceed(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" onchange="saveqty(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" type="text" value="' + qty + '" name="qty" id="sizeqtyrow_' + sizeqtycolorrowID + '"/></td>\n\
         <td><input onkeydown="inserttabrow(event,' + wororderdetailsID + ',' + sizeqtycolorrowID + ');" onchange="savecolor(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" type="text" value="' + color + '" name="color" id="color_' + sizeqtycolorrowID + '"/></td>\n\
         <td>\n\
         <a href="#" onclick="editsizeqtycolorDBrowAjaxcall(' + sizeqtycolorrowID + ');return false;">Edit</a>\n\
         <a href="#" onclick="deletesizeqtycolorDBrow(' + sizeqtycolorrowID + ');return false;">Delete</a></td>\n\
         </tr>';
         //<input onchange="savesize(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);"  type="text" value="' + prevsize + '" name="size" id="size_' + sizeqtycolorrowID + '"/>                    
         $('#sizeqtycolorDB_tbl_' + wororderdetailsID).append(html);
         */

        $('#size_' + sizeqtycolorrowID).focus();
        //saveqty(wororderdetailsID, sizeqtycolorrowID, prevqty);


        return false;
    }


    function getSizeList(wororderdetailsID, sizeqtycolorrowID, prevsize) {
        var html = '<select id="sizecombooption_' + sizeqtycolorrowID + '" onchange="$(\'#sizecombo_' + sizeqtycolorrowID + '\').val($(this).val()).trigger(\'change\');" type="text" value="' + prevsize + '" name="size" >';
        html = html + '<option value="">Select Size</option>';
        html = html + sizeoptionhtml;


        html = html + '</select>';
        html = html + '<input onchange="savesize(' + wororderdetailsID + ',' + sizeqtycolorrowID + ',this.value);" id="sizecombo_' + sizeqtycolorrowID + '" style="margin-left: -220px; width: 190px; height: 1.2em; border: 1px solid #DDD;" />';
        return html;
    }


    function savedtlrow(dtlID) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("Workorderdetailssizecolor/fetchRowHtmlByDtlID"); ?>',
            data: {
                'id': dtlID
            },
            dataType: 'html',
            success: function(result) {
                $("#sizeqtycolorDB_tbl_" + dtlID + ' tbody').find("tr:gt(0)").remove();
                $("#sizeqtycolorDB_tbl_" + dtlID + ' tbody').append(result);
                $('#sizeQtyClrSaveChangesBtn_' + dtlID).hide();

                validateQtyMismatch({
                    workorderdetailsID: dtlID
                });


            },
            error: function(result) {

            }
        });
    }




    function deleteRecord(id) {
        bootbox.prompt({
            title: "To delete the select item(s), please enter the word <b>'delete'</b> then click ok",
            callback: function(result) {
                if (result == 'DELETE' || result == 'delete') {
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo Yii::app()->createUrl("workorderdetails/deleteAjax"); ?>',
                        data: {
                            'id': id
                        },
                        dataType: 'json',
                        success: function(result) {

                            if (result.status == 'success') {
                                $('#row_' + id).remove();
                                calculateTotal(null);
                            } else if (result.status == 'warning') {

                                bootbox.alert({
                                    title: 'Warning!',
                                    message: result.message,
                                    size: 'large'
                                });
                            }



                        },
                        error: function(result) {
                            consol.log('Cannot delete this item! Item is being used!');
                        }
                    });
                }
            }
        });

    }

    function deleteMultipleRecords(arr) {

        bootbox.prompt({
            title: "To delete the select item(s), please enter the word <b>'delete'</b> then click ok",
            callback: function(result) {
                if (result == 'DELETE' || result == 'delete') {
                    var jsonString = JSON.stringify(arr);
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo Yii::app()->createUrl("workorderdetails/deleteMultipleAjax"); ?>',
                        data: {
                            'wororderDtlArr': jsonString
                        },
                        dataType: 'json',
                        success: function(result) {

                            if (result.status == 'success') {
                                $.each(arr, function(index, value) {
                                    $('#row_' + value).remove();

                                });

                                calculateTotal(null);
                            } else if (result.status == 'warning') {

                                bootbox.alert({
                                    title: 'Warning!',
                                    message: result.message,
                                    size: 'large'
                                });
                            }




                        },
                        error: function(result) {
                            console.log('Cannot delete this item(s)! Item(s) are being used!');
                        }
                    });
                }
            }
        });

    }

    function inputkeyupcalculation(e) {


        var attrID = $(e).attr('id');
        var arr = attrID.split('_');

        var productDetailID = arr[1];

        if (arr[0] == 'prodqty') {
            /*
             * call server function callsellpriceexGST
             * calculate sell price excluding GST
             * update qty on DB
             * update product price & deco price on DB
             * update ex and inc totals
             * set return sell price ex GST 
             * fire onchane event on sellPriceExGST field
             * 
             */
            var enteredQty = $('#' + attrID).val();
            calLinePrice(productDetailID, enteredQty);
        }


    }


    function calLinePrice(productDetailID, enteredQty) {

        bootbox.prompt({
            title: "You are quanity changing may effect to the cost price!",
            message: '<p>Please select an option below:</p>',
            inputType: 'radio',
            inputOptions: [{
                    text: 'Use the cost price entered',
                    value: '1',
                },
                {
                    text: 'Look up the current cost price',
                    value: '2',
                },
            ],
            callback: function(qtyOptionResult) {

                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl("workorderdetails/calSellPriceExGST"); ?>',
                    data: {
                        'id': productDetailID,
                        'qty': enteredQty,
                        'qtyPriceOption': qtyOptionResult
                    },
                    dataType: 'json',
                    success: function(result) {

                        if (result.success == true) {
                            $('#sellpriceexvat_' + productDetailID).val(result.sellPriceExGST);
                            //$('#sellpriceincvat_' + productDetailID).val(result.sellPriceIncVat);
                            $('#totexvat_' + productDetailID).val(result.totExVat);
                            //$('#totincvat_' + productDetailID).val(result.totIncVat);
                            calculateTotal(productDetailID);
                        }
                        //                    else if(result.success == false){
                        //                       
                        //                    }

                        //fireTotal(productDetailID);
                    },
                    error: function(result) {

                    }
                });



            }
        });


    }



    $(document).ready(function() {

        $('#backtotop').click(function() {
            $('html, body').animate({
                scrollTop: 0
            }, 800);
            return false;
        });

        setGST();
        fetchSizeOptions();

        function fetchSizeOptions() {
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("productSizes/populateSizeOptions"); ?>',
                data: {
                    'fetchsizes': true
                },
                dataType: 'html',
                success: function(result) {
                    sizeoptionhtml = result;
                },
                error: function(result) {

                }
            });
        }

        $("#Workorderdetails_productsku").change(function() {

            $.ajax({
                type: "POST",
                url: '<?php echo Yii::app()->createUrl("workorderdetails/filterDesc"); ?>',
                data: {
                    'productsku': this.value
                },
                dataType: 'json',
                success: function(data) {

                    $("#Workorderdetails_prdlngdesc").val(data.longdesc);
                    $("#Workorderdetails_prdsrtdesc").val(data.shortdesc);


                },
                error: function(data) {

                },
            });

        });


        $("#Workorderdetails_decprtnam").change(function() {

            $.ajax({
                type: "POST",
                url: '<?php echo Yii::app()->createUrl("workorderdetails/filterDecoration"); ?>',
                data: {
                    'decprtnam': this.value
                },
                dataType: 'json',
                success: function(data) {

                    $("#Workorderdetails_decdesc").val(data.decorateDesc);



                },
                error: function(data) {

                },
            });

        });




        $('.saveimg, .uploadimg, .viewsizecolor, .viewlongdesc').hover(
            function() {
                $(this).addClass('mouseoverbutton');
            },
            function() {
                $(this).removeClass('mouseoverbutton');
            }
        )

        $('#Workorderdetails_custmproduct').keyup(function(event) {

            if ($(this).val().length > 0) {
                $('#Workorderdetails_productsku').prop("disabled", true);
                $('#Workorderdetails_prdsrtdesc').prop("disabled", true);
            } else {
                $('#Workorderdetails_productsku').prop("disabled", false);
                $('#Workorderdetails_prdsrtdesc').prop("disabled", false);
            }

        });

        $('#Workorderdetails_productsku').change(function(event) {

            if ($(this).val().length > 0) {
                $('#Workorderdetails_custmproduct').prop("disabled", true);
            } else {
                $('#Workorderdetails_custmproduct').prop("disabled", false);
            }

        });

        $('#Workorderdetails_customdecoration').keyup(function(event) {

            if ($(this).val().length > 0) {
                $('#Workorderdetails_decprtnam').prop("disabled", true);
            } else {
                $('#Workorderdetails_decprtnam').prop("disabled", false);
            }

        });

        $('#Workorderdetails_decprtnam').change(function(event) {

            if ($(this).val().length > 0) {
                $('#Workorderdetails_customdecoration').prop("disabled", true);
            } else {
                $('#Workorderdetails_customdecoration').prop("disabled", false);
            }

        });



        $('.button-column img').click(function() {
            if ($(this).attr("src") === 'images/more_details.png') {
                $(this).attr("src", 'images/less_details.png');
            } else {
                $(this).attr("src", 'images/more_details.png');
            }

        });

        $('#addsizeqtyrow').click(function() {


            var rowCount = $('#sizeqtycolor_tbl tr').length;
            var html = '<tr id="sizeqtyrow_' + rowCount + '">\n\
                        <td>' + rowCount + '</td>\n\
                        <td><input  type="text" value="" name="Workorderdetailssizecolor[size][' + rowCount + ']" id=""/></td>\n\
                        <td><input   type="text" value="" name="Workorderdetailssizecolor[qty][' + rowCount + ']" id=""/></td>\n\
                        <td><input  type="text" value="" name="Workorderdetailssizecolor[color][' + rowCount + ']" id=""/></td>\n\
                        <td><a href="" onclick="deletesizeqtyrow(' + rowCount + ');return false;">Delete</a></td>\n\
                        </tr>';
            $('#sizeqtycolor_tbl').append(html);

        });






        $('#quatation-details-grid :input').change(function() {
            inputkeyupcalculation(this);

        });


        var enableSubmit = function(ele) {
            $(ele).removeAttr("disabled");
        }

        $("#post-submit-btn").click(function() {
            var that = this;
            $(this).attr("disabled", true);
            setTimeout(function() {
                enableSubmit(that)
            }, 3000);
        });


        $('#quote_general input,textarea').change(function() {

            var customerURL = '<?php echo Yii::app()->createUrl("customer/ajaxFiledUpdate"); ?>';
            var quoteURL = '<?php echo Yii::app()->createUrl("quatation/ajaxFiledUpdate"); ?>';
            var liveURL = '';

            var cutomerfieldarr = ['cusnam', 'custel', 'cusadd1', 'cusadd2', 'cusadd3', 'custown', 'cusstate', 'cuspostcode', 'cusemail', 'cusfax'];
            var quotefieldsarr = ['quotecomments'];

            if (jQuery.inArray($(this).attr('name'), cutomerfieldarr) > -1) {
                //it's a field of customer table
                liveURL = customerURL;
            } else {
                liveURL = quoteURL;
            }

            var ID = $(this).attr('id');
            var field = $(this).attr('name');
            var value = $(this).val();
            var messageElmID = $(this).next('span').attr('id');
            $.ajax({
                type: 'POST',
                url: liveURL,
                data: {
                    'id': ID,
                    'field': field,
                    'value': value
                },
                dataType: 'json',
                success: function(result) {
                    if (result.success === true) {


                        $('#' + messageElmID).fadeIn(500).fadeOut(1500);

                    } else {

                    }
                },
                error: function(result) {

                }
            });


        });


        var quote_general_visible = true;
        $('#quote-general-btn').click(function() {
            if (quote_general_visible === true) {
                $('#workorder-general-details').slideUp(500);
                $(this).val('Show');

                var quotenumber = $("#quoteID").val();
                var customername = $("input[name=cusnam]").val();

                $('#quoteheaderspan').empty();
                $('#quoteheaderspan').text('Quotation number : ' + quotenumber + ' - ' + 'Customer name : ' + customername);
                quote_general_visible = false;

            } else {
                $('#workorder-general-details').slideDown(500);
                $(this).val('Hide');
                $('#quoteheaderspan').empty();
                $('#quoteheaderspan').text('Quotation - General Details');
                quote_general_visible = true;
            }
        });



    });





    function setGST() {

        var url = '<?php echo Yii::app()->createUrl("globalVars/getVar"); ?>';
        $.ajax({
            type: 'POST',
            url: url,
            data: {
                'type': 'GST'
            },
            dataType: 'json',
            success: function(result) {
                GST = result.GST;

            },
            error: function(result) {

            }
        });
    }









    function get2decimalpoint(value) {

        var str = value.toString();
        var arr = str.split('.');
        var decimalstr = '';
        var decimalarr = null;
        var with2decimalplace = '';
        if (arr.length == 2) {
            decimalstr = arr[1];
            decimalarr = decimalstr.split('');
            with2decimalplace = arr[0] + '.';
            $.each(decimalarr, function(index, value) {
                if (index < 3) {
                    with2decimalplace = with2decimalplace + '' + value;
                }

            });
        } else {
            with2decimalplace = arr[0] + '.00';
        }
        return with2decimalplace;
    }

    function getdecimalpoint(value, points) {

        var str = value.toString();
        var arr = str.split('.');
        var decimalstr = '';
        var decimalarr = null;
        var with2decimalplace = '';
        if (arr.length == 2) {
            decimalstr = arr[1];
            decimalarr = decimalstr.split('');
            with2decimalplace = arr[0] + '.';
            $.each(decimalarr, function(index, value) {
                if (index < points) {
                    with2decimalplace = with2decimalplace + '' + value;
                }

            });
        } else {
            with2decimalplace = arr[0] + '.00';
        }
        return with2decimalplace;
    }

    function calculateTotal(detailsID) {

        var type;
        if (detailsID !== null) {
            type = 'DTL';
        } else {
            detailsID = $('#modelId').val();
            type = 'MDL';
        }

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorderdetails/calculateFullTotal"); ?>',
            data: {
                'id': detailsID,
                'type': type
            },
            dataType: 'json',
            success: function(result) {
                $('#subTotalVal').text(result.subTotal);
                $('#subTotalWithSurchargeVal').text(result.subTotalWithSurcharge);
                $('#gstTotalVal').text(result.gstTotal);
                $('#fullTotalVal').text(result.total);
            },
            error: function(result) {

            }
        });
    }

    var visibledRowID = [];

    function subrowvisible(id) {



        if (jQuery.inArray(id, visibledRowID) != -1) {
            visibledRowID = jQuery.grep(visibledRowID, function(value) {
                return value != id;
            });

            $('#subrowdiv_' + id).slideUp(300);
            $('#subrow_' + id).hide(500);
            $('#mainrow_' + id).css("border", "none");
        } else {
            visibledRowID.push(id);
            $('#subrow_' + id).show();
            $('#subrowdiv_' + id).slideDown(300);
            $('#mainrow_' + id).css("border-top", "#CCC solid 2px");


        }


        if ($('#moredtl_imgnode_' + id).attr("src") === 'images/more_details.png') {
            $('#moredtl_imgnode_' + id).attr("src", 'images/less_details.png');
        } else {
            $('#moredtl_imgnode_' + id).attr("src", 'images/more_details.png');
        }
    }




    function send() {

        var fd = new FormData($("#workorder-from")[0]);
        var e = document.getElementById("subrowimage");
        fd.append("Workorderdetails[image]", $(e)[0].files[0]);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("workorderdetails/uploadPost"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {
                addmainrow(result);

            },
            complete: function() {
                // success alerts
            },
            error: function(data) {

            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }


    function addmainrow(html) {

        var numberOfRows = $('.maincell').length;
        numberOfRows++;
        //$('#showhtml').text(html);

        var lastrowclass = $('#maintblbody > tr:last').attr('class');

        $('#maintblbody').append(html);

        // $('#maintblbody > tr:last .counter').html(numberOfRows);

        if (lastrowclass === 'foo') {
            $('#maintblbody > tr:last').attr('class', 'bar');
        } else {
            $('#maintblbody > tr:last').attr('class', 'foo');
        }



        $(document).on('keyup', 'input', function() {
            inputkeyupcalculation(this);
        });

        $('#rowaddedsuccess').fadeIn(500).fadeOut(5000);
        scrollToAnchor('here');
        calculateTotal(null);



    }

    function scrollToAnchor(aid) {
        var aTag = $("a[name='" + aid + "']");
        $('html,body').animate({
            scrollTop: aTag.offset().top
        }, 1000);
    }




    function deletesizeqtyrow(row) {
        $('#sizeqtyrow_' + row).remove();

        var count = 0;
        $('#sizeqtycolor_tbl tr').not(":first").each(function() {

            count++;
            $(this).attr('id', 'sizeqtyrow_' + count);
            $(this).children("td:first").empty();
            $(this).children("td:first").html(count);

            $(this).children("td:last").empty();
            $(this).children("td:last").html('<a href="" onclick="deletesizeqtyrow(' + count + ');return false;">Delete</a>');

        });
        return false;
    }


    function deletesizeqtycolorDBrow(id) {

        if (confirm('Are you sure you want to delete this item?')) {
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("workorderdetailssizecolor/deleteAjax"); ?>',
                data: {
                    'id': id
                },
                dataType: 'json',
                success: function(result) {

                    afterdeleteSizeQtyColorDBRow(id);


                    //checkQtyDiff(result.wrkodrdtlID);
                    validateQtyMismatch({
                        workorderdetailsID: result.wrkodrdtlID
                    });

                },
                error: function(result) {

                }
            });
        }
    }

    function afterdeleteSizeQtyColorDBRow(id) {
        $('#sizeqtycolorDBrow_' + id).remove();

        var count = 0;
        $('#sizeqtycolorDB_tbl tr').not(":first").each(function() {
            if ($(this).attr('id') !== undefined) {
                count++;

                $(this).children("td:first").empty();
                $(this).children("td:first").html(count);
            }
        });
        return false;
    }


    var visiblewrokpanel = false;

    function workorderpanelvisible() {
        if (visiblewrokpanel == false) {
            $('#work-add-btn').val('Hide');
            $('#workorderpanel').slideDown(500);
            visiblewrokpanel = true;
        } else {
            $('#work-add-btn').val('Show');
            $('#workorderpanel').slideUp(500);
            visiblewrokpanel = false;
        }

    }

    var longdesvisible = false;

    function viewlongdecription(id) {

        if (!$('#prodlngdesc_' + id).is(":visible")) {
            $('#prodlngdesc_' + id).slideDown(300);
            $('#viewlongdesc_' + id).empty();
            $('#viewlongdesc_' + id).html('Hide long description');
        } else {
            $('#prodlngdesc_' + id).slideUp(300);
            $('#viewlongdesc_' + id).empty();
            $('#viewlongdesc_' + id).html('View long description');
        }

    }

    var fileselected = null;

    function uploadimg(id) {
        $('#uploadimgfile_' + id).trigger('click');
    }

    function imageChoosed(id, val) {

        fileselected = $.trim(val);
        if (fileselected !== null && fileselected !== '') {
            $('#saveimg_' + id).empty();
            $('#saveimg_' + id).html('Save Image <br>(' + fileselected + ')');
            $('#saveimg_' + id).show(500);
        }
    }

    function saveimg(id) {
        var fd = new FormData($("#uploadimgform_" + id)[0]);
        var e = document.getElementById("uploadimgfile_" + id);
        fd.append("Workorderdetails[image]", $(e)[0].files[0]);
        fd.append("Workorderdetails[id]", id);
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("workorderdetails/uploadImg"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {

                $('#workorddetimg_' + id).attr('src', result);

                $('#saveimg_' + id).hide(500);
                $('#saveimg_' + id).empty();
            },
            complete: function() {
                // success alerts
            },
            error: function(data) {

            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }


    function hide(id) {
        if ($('#' + id).is(":visible")) {
            $('#' + id).slideUp(500);
            $('#' + id + '-fold').attr("src", 'images/more_details.png');
        } else {
            $('#' + id).slideDown(500);
            $('#' + id + '-fold').attr("src", 'images/less_details.png');
        }
    }



    function showcentermodel(id) {
        $("#" + id).modal('show').css({
            'margin-top': function() {
                return -($(this).height() / 2);
            },
            'margin-left': function() {
                return -($(this).width() / 2);
            },
        })
    }


    //    function updateSOHeader() {
    //
    //        var fd = new FormData($("#so-header-form")[0]);
    //        fd.append("Workorder[id]", $('#so_h_wo_id').val());
    //        fd.append("Workorder[ws_user_id]", $('#so_h_wo_ws_user_id').val());
    //        fd.append("Workorder[prd_cordinator_id]", $('#so_h_wo_prd_cordinator_id').val());
    //        fd.append("Workorder[customerpono]", $('#Workorder_customerpono').val());
    //        fd.append("Workorder[dueDate]", $('#Workorder_dueDate').val());
    //        fd.append("Workorder[followupStatus]", $('#so_h_wo_followupStatus').val());
    //
    //        $.ajax({
    //            url: 'Yii::app()->createUrl("workorder/uploadAjaxHeader")',
    //            type: 'POST',
    //            data: fd,
    //            datatype: 'json',
    //            // async: false,
    //            beforeSend: function () {
    //                // do some loading options
    //            },
    //            success: function (result) {
    //
    //                $('#so-header-chnges-msg').fadeIn(500).fadeOut(1500);
    //                $.fn.yiiGridView.update("sales-log-grid");
    //
    //
    //            },
    //            complete: function () {
    //                // success alerts
    //            },
    //            error: function (data) {
    //              
    //            },
    //            cache: false,
    //            contentType: false,
    //            processData: false
    //        });
    //    }


    $(document).on('change', '#so-header-details input,select, textarea', function() {

        //list of attributes that should be ignored, have been defined in array
        if (jQuery.inArray($(this).attr('id'), ['surcharge_id']) === -1) {
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("workorder/uploadAjaxHeader"); ?>',
                data: {
                    'model-id': $('#modelId').val(),
                    'attr-model-field-pair': $(this).attr('name'),
                    'attr-value': $(this).val()
                },
                dataType: 'json',
                success: function(result) {

                },
                error: function(result) {

                }
            });
        }
    });

    $(document).on('change', '#surcharge_id', function() {


        $.ajax({
            type: 'GET',
            url: '<?php echo Yii::app()->createUrl("surcharge/index"); ?>',
            data: {
                'id': $(this).val()
            },
            dataType: 'json',
            success: function(result) {
                $('#surcharge_rate').val(result.rate);
                $('#surcharge_rate').trigger('change');
            },
            error: function(result) {

            }
        });
    });

    $(document).on('change', '#surcharge_rate', function() {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("workorder/updateSurcharge"); ?>',
            data: {
                'id': $('#modelId').val(),
                'surcharge_id': $('#surcharge_id').val(),
                'surcharge_rate': $(this).val()
            },
            dataType: 'json',
            success: function(result) {
                calculateTotal(null);
            },
            error: function(result) {

            }
        });
    });
</script>


<?php
//if (isset(Yii::app()->session['sizearray']))
//print_r($workoderDetails->workorderId);

$this->breadcrumbs = array(
    'Quatations' => array('index'),
    $model->id,
);

$confirmorder = null;
if (in_array($workorder->status_id, array(Status::SYS_STATUS_NEW, Status::SYS_STATUS_PENDING_APPROVAL))) {
    $confirmorder = array('label' => 'Confirm Order', 'url' => array('workorder/confirm', 'id' => $workorder->id));
}

$sendtoapproval = null;
//if (Yii::app()->user->title != 'Administrator' && $workorder->status_id == 1) {
//
//    $sendtoapproval = array('label' => 'Send to Approval', 'url' => array('workorder/sendToaApproval', 'id' => $workorder->id));
//}

$converttojob = null;
if (in_array(Yii::app()->user->title, array('Administrator')) && $workorder->status_id == 2) {
    $converttojob = array('label' => 'Convert Quotation to Job', 'url' => array('workorder/converttoJob', 'id' => $workorder->id));
}

$jobinfocusmenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}

$backtoJob = null;
$job = Jobs::model()->find(array('condition' => "workorder_id = '{$workorder->id}'"));
if (!empty($job)) {
    $backtoJob = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

$this->menu = array(
    //array('label'=>'Update Quatation', 'url'=>array('update', 'id'=>$model->id)),
    //array('label'=>'Delete Quatation', 'url'=>'#', 'linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?')),
    $jobinfocusmenu,
    $backtoJob,
    $confirmorder,
    $sendtoapproval,
    $converttojob,
    array('label' => 'Manage Sales Orders', 'url' => array('admin')),
);
?>

<h1>Edit Sales Order #<?php echo $workorder->salesorderNumber; ?></h1>
<input id="SupplierMarkUp" type="hidden" value="<?php echo GlobalVars::get('SupplierMarkUp'); ?>" />
<input id="modelId" type="hidden" name="modelId" value="<?php echo $workorder->id; ?>" />
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<?php
include '_model_popup.php';
?>
<ul class="nav nav-tabs" role="tablist">

    <li class="active"><a href="#so-header-sec" role="tab" data-toggle="tab" onclick="setTab('so-header-sec');">SO Header Details</a></li>

    <li><a href="#quote-header-sec" role="tab" data-toggle="tab" onclick="setTab('quote-header-sec');">Quotation Header Details</a></li>

    <li><a href="#so-dtl-sec" role="tab" data-toggle="tab" onclick="setTab('so-dtl-sec');">Sales Order Details</a></li>

    <li><a href="#crm-sec" role="tab" data-toggle="tab" onclick="setTab('crm-sec');">CRM</a></li>

    <li><a href="#file-attachment-sec" role="tab" data-toggle="tab" onclick="setTab('file-attachment-sec');">File Attachments</a></li>

    <li><a href="#sign-off-sec" role="tab" data-toggle="tab" onclick="setTab('sign-off-sec');">Sign Off Terms</a></li>

    <li><a href="#all-in-one-sec" role="tab" data-toggle="tab" onclick="setTab('all-in-one-sec');">All</a></li>



</ul>
<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="so-header-sec" style="padding-top: 0;margin-top: 0;">
        <div id="load-feel" class="loadfeel"></div>
        <div id="so-header-sec-wrap">
            <?php include '_form_so_header_section.php'; ?>
        </div>

    </div>
    <div class="tab-pane view" id="quote-header-sec" style="padding-top: 0;margin-top: 0;">
        <div id="quote-header-sec-wrap">
            <?php include '_form_quote_header_section.php'; ?>
        </div>

    </div>
    <div class="tab-pane view" id="so-dtl-sec" style="padding-top: 0;margin-top: 0;">
        <div id="so-dtl-sec-wrap">
            <?php include '_form_so_dtl_section.php'; ?>
        </div>

    </div>
    <div class="tab-pane view" id="crm-sec" style="padding-top: 0;margin-top: 0;">
        <div id="crm-sec-wrap">
            <?php include '_form_crm_section.php'; ?>
        </div>

    </div>

    <div class="tab-pane view" id="file-attachment-sec" style="padding-top: 0;margin-top: 0;">
        <div id="file-attachment-sec-wrap">
            <?php include '_file_attachment_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="sign-off-sec" style="padding-top: 0;margin-top: 0;">
        <div id="sign-off-sec-wrap">
            <?php include '_form_sign_off_section.php'; ?>
        </div>

    </div>
    <div class="tab-pane view" id="all-in-one-sec" style="padding-top: 0;margin-top: 0;">

    </div>

    <script>
        function setTab(id) {
            if (id == 'all-in-one-sec') {
                runloadfeel('all-in-one-sec');
                $('#so-header-sec-wrap').appendTo('#all-in-one-sec');
                $('#quote-header-sec-wrap').appendTo('#all-in-one-sec');
                $('#so-dtl-sec-wrap').appendTo('#all-in-one-sec');
                $('#crm-sec-wrap').appendTo('#all-in-one-sec');
                $('#sign-off-sec-wrap').appendTo('#all-in-one-sec');
            } else if (id == 'so-header-sec') {
                runloadfeel('so-header-sec');
                $('#so-header-sec-wrap').appendTo('#so-header-sec');
            } else if (id == 'quote-header-sec') {
                runloadfeel('quote-header-sec');
                $('#quote-header-sec-wrap').appendTo('#quote-header-sec');
            } else if (id == 'so-dtl-sec') {
                runloadfeel('so-dtl-sec');
                $('#so-dtl-sec-wrap').appendTo('#so-dtl-sec');
            } else if (id == 'crm-sec') {
                runloadfeel('crm-sec');
                $('#crm-sec-wrap').appendTo('#crm-sec');
            } else if (id == 'file-attachment-sec') {
                runloadfeel('file-attachment-sec');
                $('#file-attachment-sec-wrap').appendTo('#file-attachment-sec');
            } else if (id == 'sign-off-sec') {
                runloadfeel('sign-off-sec');
                $('#sign-off-sec-wrap').appendTo('#sign-off-sec');
            }

        }

        function runloadfeel(into) {
            $('#load-feel').appendTo('#' + into);

            $('#load-feel').css('width', '0');
            $('#load-feel').animate({
                width: '97.8%'
            }, 500);
        }
    </script>

</div>



<div style="display: inline;">

    <?php
    if (in_array(Yii::app()->user->title, array('Administrator', 'Coordinator')) && $workorder->status_id == 1) {
        if ($qtymismatchresult['isQtyDiff'] == false)
            echo CHtml::button('Confirm Order', array('submit' => array('workorder/confirm', 'id' => $workorder->id)));
    }

    if (in_array(Yii::app()->user->title, array('Administrator', 'Coordinator')) && $workorder->status_id == 1) {
        if ($qtymismatchresult['isQtyDiff'] == false)
            echo CHtml::button('Send to Approval', array('submit' => array('workorder/sendToaApproval', 'id' => $workorder->id)));
    }

    if (in_array(Yii::app()->user->title, array('Administrator', 'Coordinator')) && $workorder->status_id == 2) {
        if ($qtymismatchresult['isQtyDiff'] == false)
            echo CHtml::button('Convert Quotation to Job', array('submit' => array('workorder/converttoJob', 'id' => $workorder->id)));
    }
    ?>
</div>
<div class="clear"></div>

<div style="display: inline;float: right;">
    <?php
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($workorder->id)", 'style' => 'float:right;'));
    //echo CHtml::button('Print Kulbardi PDF', array('onclick' => "printKulbardiPDF($workorder->id)",'style'=>'float:right;background-color:#C45C1B;'));
    echo CHtml::button('Send Sales Order', array('onclick' => "sendEmail($workorder->id,'SalesOrder')", 'style' => 'float:right;'));
    ?>
</div>
<div style="display: inline;float: left;">
    <?php
    echo CHtml::button('Back to Top', array('id' => 'backtotop', 'style' => 'float:right;'));
    ?>
</div>
<script>
    function getPDFInputOptions() {
        var options = {};
        options.selected = ['prddshow=1', 'prices_show=1', 'cutmz_show=1', 'notes_show=1'];
        options.inputOptions = [{
                text: 'Product Details',
                value: 'prddshow=1',
            },
            {
                text: 'Price Details',
                value: 'prices_show=1',
            },
            {
                text: 'Customisation Details',
                value: 'cutmz_show=1',
            },
            {
                text: 'Show Notes',
                value: 'notes_show=1',
            }
        ];

        return options;
    }

    function printPDF(id) {
        var options = getPDFInputOptions();
        bootbox.prompt({
            title: "PDF Print Options",
            value: options.selected,
            inputType: 'checkbox',
            inputOptions: options.inputOptions,
            callback: function(result) {
                if (result) {
                    let query = 'index.php?r=Workorder/print&id=' + id;
                    $.each(result, function(index, value) {
                        query += '&' + value;
                    });
                    var win = window.open(query);
                }
            }
        });
    }


    function printKulbardiPDF(id) {

        var show_prddtl = 0;
        if ($('#prddtl_flag').is(':checked')) {
            show_prddtl = 1;
        }
        var cutmz_show = $('#custmz_flag').is(':checked') ? 1 : 0;
        var notes_show = $('#notes_flag').is(':checked') ? 1 : 0;
        var prices_show = $('#prices_flag').is(':checked') ? 1 : 0;
        var win = window.open('index.php?r=Workorder/print&id=' + id + '&prddshow=' + show_prddtl + '&cutmz_show=' +
            cutmz_show + '&notes_show=' + notes_show + '&prices_show=' + prices_show + '&tempt=2');
    }

    function sendEmail(id, emailtype) {
        var options = getPDFInputOptions();
        bootbox.prompt({
            title: "Send SO - PDF Print Options",
            value: options.selected,
            inputType: 'checkbox',
            inputOptions: options.inputOptions,
            callback: function(result) {
                if (result) {
                    let query = 'index.php?r=emails/create&id=' + id;
                    $.each(result, function(index, value) {
                        query += '&' + value;
                    });
                    var win = window.open(query + '&type=' + emailtype);
                }
            }
        });
    }
</script>
<script>
    function saveLog() {

        var fd = new FormData($("#sales-log-form")[0]);
        //var comments = $("#SalesLog_comments").val();
        //fd.append("SalesLog[comments]", comments);

        $.ajax({
            url: '<?php echo Yii::app()->createUrl("salesLog/log"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {
                $('#log_message').empty();
                $('#log_message').html('<font id="temp_msg" style="color:green;">Saved & updated customer contacts & activities</font>');
                $('#temp_msg').fadeOut(2500);
                $.fn.yiiGridView.update("sales-log-grid");
                clearLog();

            },
            complete: function() {
                // success alerts
            },
            error: function(data) {

            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }

    function clearLog() {
        $("#SalesLog_comments").val('');
        $("#SalesLog_followupDtm").val('');
        $("#SalesLog_isIntrnl").attr('checked', false);
    }
</script>
<style>
    #quatation-details-grid table thead tr th {
        background-image: none;
        background-color: #82B8D6;

    }

    .foo {
        background-color: #E5F1F4;
    }

    .bar {
        background-color: #FFFFFF;
    }

    .maindetailrow {
        width: 100%;
    }

    .maincell {
        width: 100%;

    }

    .maintbl {
        width: 100%;

    }

    .maintbl tr {
        width: 100%;
    }

    .maintbl:first-child tr td:first-child {
        width: 3%;
    }

    .textinput {
        text-align: center;
        width: 5%;
    }

    .centercls {
        text-align: center;

    }

    .rightcls {
        text-align: right;
    }

    input.centercls {
        width: 40px;
    }

    input.rightcls {
        width: 50px;
    }

    td.button-column {
        width: 7%;
    }

    .button-column img {
        cursor: pointer;
        width: 20px;
        height: 20px;
    }

    .subrow {
        width: 100%;
        border: 1px solid #666;
        display: none;
    }

    .subrow:first-child td {
        background-color: #FFFFFF;
    }

    .subrow:first-child td {
        width: 100%;
        display: none;
    }

    .fullwidth {
        width: 100%;
    }

    .subrowgrid tr {
        width: 100%;
    }

    .subrowgrid:first-child tr {
        background-color: #e5eCf9;
    }

    .subrowgrid:last-child tr {
        border: 1px solid #DDD;
    }

    .column1 {
        width: 10%;
    }

    .column2 {
        width: 25%;
    }

    .column3 {
        width: 30%
    }

    .column2half {
        width: 25%;
    }

    .column1half {
        width: 15%;
    }

    .subrowgrid tr th {
        text-align: center;
    }

    .subrowgrid textArea {
        width: 100%;
        height: 100%;
    }

    .subrowgrid img {
        width: 100px;
        height: 100px;
    }


    .viewsizecolor {
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
    }

    .uploadimg {
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        margin-bottom: 10px;

    }

    .saveimg {
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        margin-bottom: 5px;
        display: none;

    }

    .mouseoverbutton {
        background-color: #DDD;
        border: 1px solid #FFD324;
    }

    .sizeqtycolordiv {
        display: none;
    }

    .sizeqtycolordiv table {
        width: 100%;
    }

    .sizeqtycolordiv table tr {
        width: 100%;
    }

    .sizeqtycolordiv table:first-child tr {
        background-color: #DDD;
    }

    .sizeqtycolordiv table tr th,
    td {
        text-align: center;
    }

    .sizeqtycolordiv table:first-child tr div {
        border: 1px solid #FFFFFF;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        width: 50%;
        margin: auto;
    }

    .sizeqtycolordiv table tr:not(:first-child) {
        background-color: #E6EFC2;
    }

    .sizeqtycolordiv table input {
        width: 100%;
    }

    .counter {}

    .savemessage {
        width: 100%;
        font-weight: bold;
        color: #00aa00;
        display: none;

    }

    .prodecs {}

    .viewlongdesc {
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        color: #fff;
        background-color: #32cd32;
        margin: 5px;
    }

    .prolngdesc {
        display: none;
    }

    .addproductdtl {
        width: 20%;
        text-align: center;
        color: #fff;
        background-color: #32cd32;
        border: 1px solid #DDD;
        border-radius: 10px;
        margin-left: auto;
        margin-right: auto;
        cursor: pointer;
    }

    #workorder-list-view tbody td {
        text-align: left;
        padding-left: 50px;

    }


    .loadfeel {
        position: absolute;
        border-top: 2px solid #82B8D6;
        width: 0%;
        margin-top: 0;
        margin: 0;
        padding: 0;
        left: 10px;
    }
</style>