<?php


Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('workorderdetails-grid', {
		data: $(this).serialize()
	});
	return false;
});
");


?>


<div class="view">
    <h1>Sales Order Approval</h1>



    <?php
    $customer = $model->workorder->quotation->customer;
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $model->workorder,
        'attributes' => array(
            'id',
            array(
                'name' => 'workorder.salesorderNumber',
                'value' => $model->workorder->salesorderNumber,
            ),
            //'quotationId',
            'quotationNumber',
            'quotation.customer.cusnam',
            array(
                'name' => 'quotation.customer.cusadd1',
                'value' => $customer->cusadd1 . ', ' . $customer->cusadd2 . ', ' . $customer->cusadd3 . ', ' . $customer->custown . ', ' . $customer->cusstate,
            ),
            array(
                'name' => 'quotation.customer.cusemail',
                'value' => $customer->cusemail,
            ),
            array(
                'name' => 'quotation.customer.custel',
                'value' => $customer->custel,
            ),
            array(
                'name' => 'prd_cordinator_id',
                'value' => User::model()->findByPk($model->workorder->prd_cordinator_id)->username,
            ),
            array(
                'name' => 'createddate',
                'value' => date(GlobalVars::get("DateFormat"), strtotime($model->createddate)),
            ),
        ),
    ));
    ?>
</div>

<div class="clear"></div>


<div class="view">
    <h3>Sales Order Details</h3>
    <div id="sales-order-div">


<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'workorderdetails-grid',
    'dataProvider' => $model->search(),
    'filter' => null,
    'columns' => array(
        'id',
        array(
            'name' => 'image',
            'type' => 'raw',
            'value' => 'CHtml::image($data->getImg())',
        //'htmlOptions' => array('style' => 'width:100px;'),
        ),
        array(
            'name' => 'productsku',
            'value' => '!empty($data->productsku) ? $data->productsku . " <br> " . $data->prdsrtdesc : $data->custmproduct ',
            'type' => 'raw',
        ),
        array(
            'name' => 'prdlngdesc',
            'type' => 'raw',
            //'htmlOptions' => array('style' => 'width:200px;'),
            'value' => '$data->prdlngdesc . $data->getSizeQtyColorTable() ',
        ),
        array(
            'name' => 'decprtnam',
            'type' => 'raw',
            //'htmlOptions' => array('style' => 'width:150px;'),
            'value' => '!empty($data->decprtnam) ? $data->decdesc . $data->getCustomizationDetail() : $data->customdecoration . $data->getCustomizationDetail()',
            'footer' => 'Total',
        ),
        array(
            'name' => 'prodQty',
            'htmlOptions' => array('style' => 'text-align:center'),
            'type' => 'raw',
            'footer' => '<div style="font-size: 1.2em; font-weight: bold; text-align: center;">' . $model->getProdQtyTotal() . '</div>',
        ),
//         array(
//            'name' => 'supplier.supnam',
//            'type' => 'raw',
//            'value' => 'CHtml::link($data->supplier->supnam,array("supplier/view","id"=>$data->supplier->supsno))',
//            'htmlOptions' => array('style' => 'width:100px;'),
//        ),
        array(
            'name' => 'sellPriceExVat',
            'value' => 'number_format($data->sellPriceExVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'raw',
            'footer' => '<div style="font-size: 1.2em; font-weight: bold; text-align: center;" >' . number_format($model->getSellingPriceExVatTot(), 3) . '</div>',
        ),
        array(
            'name' => 'sellPriceIncVat',
            'value' => 'number_format($data->sellPriceIncVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'raw',
            'footer' => '<div style="font-size: 1.2em; font-weight: bold; text-align: center;">' . number_format($model->getSellingPriceIncVatTot(), 3) . '</div>',
        ),
        array(
            'name' => 'totExVat',
            'value' => 'number_format($data->totExVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'raw',
            'footer' => '<div style="font-size: 1.2em; font-weight: bold; text-align: center;">'.number_format($model->getTotalSellPriExVatTot(), 3).'</div>',
        ),
        array(
            'name' => 'totIncVat',
            'value' => 'number_format($data->totIncVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
            'type' => 'raw',
            'footer' => '<div style="font-size: 1.2em; font-weight: bold; text-align: center;">'.number_format($model->getTotalSellPriIncVatTot(), 3).'</div>',
        ),
    /*
      'prodQty',
      'decoQty',
      'customizationDetails',
      'notes',
      'extracomments',
      'sellPriceExVat',
      'sellPriceIncVat',
      'totExVat',
      'totIncVat',
      'image',
      'createdby',
      'createddate',
     */
    ),
));
?>
    </div>
    <div class="clear"></div>
</div>


<div>
    <div style="float: right;">
        <input id="prddtl_flag" checked="checked" type="checkbox" value="1" name="prddtl_flag" style="display: inline;"/>
        <label style="width: 250px;display: inline;">Show Product Details in PDF</label>
    </div>
</div>
<div class="clear"></div>
<div >
    
    <div style="float: left;">
<?php
$workorderID = $model->workorder->id;

echo CHtml::button('Approve', array('onclick' => "cusApproval($workorderID)", 'style' => 'float:left;'));
echo CHtml::button('Reject', array('onclick' => "cusReject($workorderID)", 'style' => 'background-color:#CC3300;float:left;'));
?>
    </div>   

    <div style="float: right;">
<?php


echo CHtml::button('Print PDF', array('onclick' => "printPDF($workorderID)", 'style' => 'float:right;'));
?>
    </div>    


</div>
<script>
        function printPDF(id) {
            var show_prddtl = 0;
            if ($('#prddtl_flag').is(':checked')) {
                show_prddtl = 1;
            }
            var win = window.open('index.php?r=workorder/print&id=' + id + '&prddshow=' + show_prddtl);
        }

        function cusApproval(id) {
           window.location.replace('index.php?r=workorder/cusApproval&id=' + id);
            
        }
        
        function cusReject(id) {
           window.location.replace('index.php?r=workorder/cusReject&id=' + id);
            
        }


        
</script>


