<?php
$this->breadcrumbs=array(
	'Xero Accounts'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List XeroAccount', 'url'=>array('index')),
	array('label'=>'Refresh Xero Accounts', 'url'=>array('sync')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('xero-account-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Xero Accounts</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'xero-account-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		//'account_uuid',
		'code',
		'name',
		'type',
		'tax_type',
		/*
		'bank_account_number',
		'bank_account_type',
		
		*/
		'currency_code',
		'description',
		'status',
		array(
            'class' => 'CButtonColumn',
            'template' => '{view}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),                
            )
        ),
	),
)); ?>
