<?php

require 'vendor/autoload.php';

//require_once('storage.php');
// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;

// Storage Classe uses sessions for storing token > extend to your DB of choice
$storage = new StorageClass();
$xeroTenantId = (string) $storage->getSession()['tenant_id'];

if ($storage->getHasExpired()) {
	$provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

	$newAccessToken = $provider->getAccessToken('refresh_token', [
		'refresh_token' => $storage->getRefreshToken()
	]);

	// Save my token, expiration and refresh token
	$storage->setToken(
			$newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
}

$config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
$config->setHost("https://api.xero.com/api.xro/2.0");

$apiInstance = new XeroAPI\XeroPHP\Api\AccountingApi(
		new GuzzleHttp\Client(), $config
);


try {
	$xeroAccounts = $apiInstance->getAccounts($xeroTenantId);


	foreach ($xeroAccounts->getAccounts() as $account) {
		$xeroAccount = XeroAccount::model()->find("account_uuid = '{$account->getAccountId()}'");
		if (!$xeroAccount) {
			$xeroAccount = new XeroAccount();
		}
		$xeroAccount->account_uuid = $account->getAccountId();
		$xeroAccount->code = $account->getCode();
		$xeroAccount->name = $account->getName();
		$xeroAccount->type = $account->getType();
		$xeroAccount->tax_type = $account->getTaxType();
		$xeroAccount->bank_account_number = $account->getBankAccountNumber();
		$xeroAccount->bank_account_type = $account->getBankAccountType();
		$xeroAccount->currency_code = $account->getCurrencyCode();
		$xeroAccount->description = $account->getDescription();
		$xeroAccount->status = $account->getStatus();
		$xeroAccount->save(false);
	}
} catch (\XeroAPI\XeroPHP\ApiException $e) {
	$error = AccountingObjectSerializer::deserialize(
					$e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
	);
	$message = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
	//print_r($error->getElements()[0]["validation_errors"]);
	//$this->redirect(array('invoice/view','id'=>$model->id, 'xrerr'=>$message));
}

$this->redirect(array('admin'));













