<h1>Xero Settings</h1>
<span class="pull right" data-xero-sso data-href="<?=Yii::app()->createUrl("xeroSetting/authorization"); ?>" data-label="Sign in with Xero"></span>
<br />
    <script src="https://edge.xero.com/platform/sso/xero-sso.js" async defer></script>
<?php
 //echo CHtml::link('Sign in to Xero', array('xeroSetting/authorization'), array('class'=>'pull right'));
	//echo '<a href="https://login.xero.com/identity/connect/authorize?response_type=code&client_id=19A6F2A5FFFF469E8FE9213FBDDF5309&redirect_uri=https://jobsperthstitch.gwshosting.com.au/jobsperthstitch/index.php?r=xeroSetting/callback&scope=openid profile email accounting.transactions&state=123">Sign In with Xero</a>';
?>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<div class="form">

    <?php		
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'emails-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
    <div class="view">
        <h3>General Settings</h3>
        <div class="row">
            <?php echo $form->labelEx($model, 'clientId'); ?>
            <?php echo $form->textField($model, 'clientId',array('style'=>'width:280px;')); ?>
            <?php echo $form->error($model, 'clientId'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'clientSecret'); ?>
            <?php echo $form->textField($model, 'clientSecret',array('style'=>'width:280px;')); ?>
            <?php echo $form->error($model, 'clientSecret'); ?>
        </div> 
		 <div class="row">
            <?php echo $form->labelEx($model, 'redirectUri'); ?>
            <?php echo $form->textField($model, 'redirectUri',array('style'=>'width:560px;')); ?>
            <?php echo $form->error($model, 'redirectUri'); ?>
        </div>
        <div class="clear"></div>
		<div class="row">
            <?php echo $form->labelEx($model, 'urlAuthorize'); ?>
            <?php echo $form->textField($model, 'urlAuthorize',array('style'=>'width:560px;')); ?>
            <?php echo $form->error($model, 'urlAuthorize'); ?>
        </div>
		<div class="clear"></div>
		<div class="row">
            <?php echo $form->labelEx($model, 'urlAccessToken'); ?>
            <?php echo $form->textField($model, 'urlAccessToken',array('style'=>'width:560px;')); ?>
            <?php echo $form->error($model, 'urlAccessToken'); ?>
        </div>
		<div class="clear"></div>
		<div class="row">
            <?php echo $form->labelEx($model, 'urlResourceOwnerDetails'); ?>
            <?php echo $form->textField($model, 'urlResourceOwnerDetails',array('style'=>'width:560px;')); ?>
            <?php echo $form->error($model, 'urlResourceOwnerDetails'); ?>
        </div>
		<div class="clear"></div>
    </div>
    <div class="clear"></div>
    <div class="view">
        <h3>Invoice Settings</h3>
        <div class="row">
            <?php echo $form->labelEx($model, 'shortDesc'); ?>
            <?php echo $form->checkBox($model, 'shortDesc', array('readonly' => true)); ?>
            <?php echo $form->error($model, 'shortDesc'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'longDesc'); ?>
            <?php echo $form->checkBox($model, 'longDesc'); ?>
            <?php echo $form->error($model, 'longDesc'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'sendInvAutoXero'); ?>
            <?php echo $form->checkBox($model, 'sendInvAutoXero'); ?>
            <?php echo $form->error($model, 'sendInvAutoXero'); ?>
        </div>
		<div class="row">
            <?php
			
			echo $form->labelEx($model, 'defalutInvoiceAccountId'); ?>
            <?php echo $form->dropDownList($model, 'defalutInvoiceAccountId', CHtml::listData(XeroAccount::model()->findAll(array('select' =>"id, CONCAT(name, ' - ', code) AS displayName", 'condition' => "type in ( 'SALES', 'REVENUE')")), 'id', 'displayName'), array("empty" => "")); ?>
        
            <?php echo $form->error($model, 'defalutInvoiceAccountId'); ?>
        </div>
        <div class="clear"></div>

    </div>
	<div class="clear"></div>
    <div class="view">
        <h3>Purchase Order Settings</h3>       
		<div class="row">
            <?php echo $form->labelEx($model, 'defalutPOAccountId'); ?>
            <?php echo $form->dropDownList($model, 'defalutPOAccountId', CHtml::listData(XeroAccount::model()->findAll(array('select' =>"id, CONCAT(name, ' - ', code) AS displayName",'condition' => "type in ( 'EXPENSE', 'REVENUE', 'DIRECTCOSTS')")), 'id', 'displayName'), array('empty' => '')); ?>
        
            <?php echo $form->error($model, 'defalutPOAccountId'); ?>
        </div>
        <div class="clear"></div>

    </div>
    <div style="width: 100%;">
        <?php echo CHtml::submitButton('Save', array('style'=>'float:right;')); ?>
    </div>
    <div class="clear"></div>




    <?php $this->endWidget(); ?>

</div><!-- form -->
<div class="clear"></div>


