<?php
date_default_timezone_set('Pacific/Auckland');
// load SOAP library

error_reporting(E_ALL & ~E_STRICT & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED & ~E_FATAL);

require_once("libs/nusoap.php");

require_once("libs/functions.php");



// load library that holds implementations of functions we're making available to the web service
// set namespace

$ns = "http://localhost/";

// create SOAP server object

$server = new soap_server();

// setup WSDL file, a WSDL file can contain multiple services

$server->configureWSDL('quotedatasave', $ns);

$server->wsdl->schemaTargetNamespace = $ns;

// register a web service method

$server->register('postQuotationNew', array('accRefNo' => 'xsd:string', 'dbid' => 'xsd:string', 'strItem' => 'xsd:string', 'quotno' => 'xsd:string', 'quoteCreated' => 'xsd:string'), // input parameters
		array('total' => 'xsd:string'), // output parameter
		$ns, // namespace
		"$ns#postQuotationNew", // soapaction
		'rpc', // style
		'encoded', // use
		'receive quote data from front end site'	 // documentation
);



// register a web service method client master data

$server->register('postNewClient', array(
	'fullname' => 'xsd:string',
	'address1' => 'xsd:string',
	'address2' => 'xsd:string',
	'suburb' => 'xsd:string',
	'postcode' => 'xsd:string',
	'telephone' => 'xsd:string',
	'email' => 'xsd:string',
	'type' => 'xsd:string',
	'imagepath' => 'xsd:string',
	'cusid' => 'xsd:string',
	'dbid' => 'xsd:string',
	'contactName' => 'xsd:string',
	'clientDiscount' => 'xsd:string',
	//added on 2020-09-12
	'customer_ref_number' => 'xsd:string',
	'acc_no' => 'xsd:string',
	'sales_person' => 'xsd:string',
	'land_phone' => 'xsd:string',
	'state' => 'xsd:string',
	'fax' => 'xsd:string',
	'newslettercheckbox' => 'xsd:string',
	'here_about_us' => 'xsd:string',
	'notes' => 'xsd:string',
	'customer_category' => 'xsd:string',
	'customer_industry' => 'xsd:string',
	'customer_status' => 'xsd:string',
	'po_required_checkbox' => 'xsd:string',
	'contact_left_checkbox' => 'xsd:string',
	'account_inactive_checkbox' => 'xsd:string',
	'address3' => 'xsd:string',
	'mobile_number' => 'xsd:string'
		), // input parameters
		array('total' => 'xsd:string'), // output parameter
		$ns, // namespace
		"$ns#postNewClient", // soapaction
		'rpc', // style
		'encoded', // use
		'receive customer data from front end site'  // documentation
);

// 24-09-2020 update create a new web service method to store supplier master data

$server->register('postNewSupplier', array(
	'fullname' => 'xsd:string',
	'address1' => 'xsd:string',
	'address2' => 'xsd:string',
	'suburb' => 'xsd:string',
	'postcode' => 'xsd:string',
	'telephone' => 'xsd:string',
	'emailcontactpersonal' => 'xsd:string',
	'type' => 'xsd:string',
	'imagepath' => 'xsd:string',
	'cusid' => 'xsd:string',
	'dbid' => 'xsd:string',
	'contactName' => 'xsd:string',
	'clientDiscount' => 'xsd:string',
	'customer_ref_number' => 'xsd:string',
	'acc_no' => 'xsd:string',
	'fax' => 'xsd:string',
	'supplier_company_name' => 'xsd:string',
	'supplier_logo' => 'xsd:string',
	'supplier_desc' => 'xsd:string',
	'externalproductlink' => 'xsd:string',
	'supplier_url' => 'xsd:string',
	'supplier_notes' => 'xsd:string',
	'rangefeatured' => 'xsd:string',
	'layouts' => 'xsd:string',
	'username' => 'xsd:string',
	'password' => 'xsd:string',
	'deliverytimes' => 'xsd:string',
	'freight' => 'xsd:string',
	'artwork' => 'xsd:string',
	'samples' => 'xsd:string',
	'offshore' => 'xsd:string',
	'sorting' => 'xsd:string',
	'state' => 'xsd:string',
	'account_number' => 'xsd:string',
	'order_email_address' => 'xsd:string'
		), // input parameters
		array('total' => 'xsd:string'), // output parameter
		$ns, // namespace
		"$ns#postNewSupplier", // soapaction
		'rpc', // style
		'encoded', // use
		'receive supplier data from front end site'  // documentation
);

function postQuotationNew($int1, $int2, $int3, $int4, $int5)
{

#return new soapval('return','xsd:integer',add($int1, $int2));
//return add($int1, $int2);

	$ss = save_quote_data($int1, $int2, $int3, $int4, $int5);

	return true;
}

function postNewClient(
		$string1, //fullname
		$string2, //address1
		$string3, //address2
		$string4, //address3
		$string5, //postcode
		$string6, //telephone
		$string7, //email
		$string8, //type
		$string9, //imagepath
		$string10, //cusid
		$string11, //dbid
		$string12, //contactName
		$string13, //clientDiscount
//added on 2020-09-12
		$string14, //customer_ref_number
		$string15, //acc_no
		$string16, //sales_person
		$string17, //land_phone
		$string18, //state
		$string19, //fax
		$string20, //newslettercheckbox
		$string21, // here_about_us
		$string22, //notes
		$string23, //customer_category
		$string24, //customer_industry
		$string25, //customer_status
		$string26, //po_required_checkbox
		$string27, //contact_left_checkbox
		$string28,//account_inactive_checkbox
		$string29,//address 3
		$string30//mobile number
		
)
{

#return new soapval('return','xsd:integer',add($int1, $int2));
//return add($int1, $int2);

	$ss = save_master_data(
			$string1, $string2, $string3, $string4, $string5, $string6, $string7, $string8, $string9, $string10, $string11, $string12, $string13,
			//added on 2020-09-12
			$string14, //customer_ref_number
			$string15, //acc_no
			$string16, //sales_person
			$string17, //land_phone
			$string18, //state
			$string19, //fax
			$string20, //newslettercheckbox
			$string21, // here_about_us
			$string22, //notes
			$string23, //customer_category
			$string24, //customer_industry
			$string25, //customer_status
			$string26, //po_required_checkbox
			$string27, //contact_left_checkbox
			$string28,//account_inactive_checkbox
			$string29,//address 3
			$string30//mobile number
	);

	return $ss;
}

/* 24-09-2020 new function to store suppler master data */

function postNewSupplier(
$string1, //fullname
		$string2, //address1
		$string3, //address2
		$string4, //address3
		$string5, //postcode
		$string6, //telephone
		$string7, //emailcontactpersonal
		$string8, //type
		$string9, //imagepath
		$string10, //cusid
		$string11, //dbid
		$string12, //contactName
		$string13, //clientDiscount
		$string14, //customer_ref_number
		$string15, //acc_no
		$string16, //fax
		$string17, //supplier_company_name
		$string18, //supplier_logo
		$string19, //supplier_desc
		$string20, //externalproductlink
		$string21, //supplier_url
		$string22, //supplier_notes
		$string23, //rangefeatured
		$string24, //layouts
		$string25, //username
		$string26, //password
		$string27, //deliverytimes
		$string28, //freight
		$string29, //artwork
		$string30, //samples
		$string31, //offshore
		$string32, //sorting
		$string33, //state
		$string34, //account_number
		$string35 //order_email_address
)
{

#return new soapval('return','xsd:integer',add($int1, $int2));
//return add($int1, $int2);

	$ss = save_supplier_master_data(
			$string1, //fullname
			$string2, //address1
			$string3, //address2
			$string4, //address3
			$string5, //postcode
			$string6, //telephone
			$string7, //email
			$string8, //type
			$string9, //imagepath
			$string10, //cusid
			$string11, //dbid
			$string12, //contactName
			$string13, //clientDiscount
			$string14, //customer_ref_number
			$string15, //acc_no
			$string16, //fax
			$string17, //supplier_company_name
			$string18, //supplier_logo
			$string19, //supplier_desc
			$string20, //externalproductlink
			$string21, //supplier_url
			$string22, //supplier_notes
			$string23, //rangefeatured
			$string24, //layouts
			$string25, //username
			$string26, //password
			$string27, //deliverytimes
			$string28, //freight
			$string29, //artwork
			$string30, //samples
			$string31, //offshore
			$string32, //sorting
			$string33, //state
			$string34, //account_number
			$string35 //order_email_address
	);

	return $ss;
}

// service the methods 

$server->service($HTTP_RAW_POST_DATA);

//--- functions -------//
//connecttodb2();
//

function get_mysql_connection()
{
	$db_host = "localhost";
	$db_user = "promofficecom_usermanadmin";
	$db_pass = ".Zbq.mGaFkq_";
	$db_data = "promofficecom_officepromo";

	$db = mysql_connect("$db_host", "$db_user", "$db_pass");
	if (!$db) {
		die("Could not connect to MySQL");
	}
	mysql_select_db("$db_data", $db) or die("could not open db" . mysql_error());

	return $db;
}

function get_mysqli_connection()
{
	$servername = "localhost";
	$username = "promofficecom_usermanadmin";
	$password = ".Zbq.mGaFkq_";
	$dbname = "promofficecom_officepromo";

	$conn = mysqli_connect($servername, $username, $password, $dbname);
// Check connection
	if (!$conn) {
		die("Connection failed: " . mysqli_connect_error());
	}


	return $conn;
}

function save_quote_data($obj1, $obj2, $obj3, $obj4, $obj5)
{

	$db = get_mysql_connection();



	$client_id = $obj1;

	$quote_id = $obj4;

	$quote_user = $obj5;

	$quote_type = 'wsquote';

	$quote_date = strftime("%Y-%m-%d"); //System Date

	$quote_time = strftime('%H:%M:%S'); //System Time



	if (preg_match("/~/", $obj3)) {



		$items_array = explode("~", $obj3);



		foreach ($items_array as $item) {



			$sql = "INSERT INTO ws_data(ws_quoteno,ws_clientid,ws_data,ws_user,ws_type,ws_date,ws_time) VALUES(";

			$sql .= "'" . $quote_id . "'";

			$sql .= ",'" . $client_id . "'";

			$sql .= ",'" . $item . "'";

			$sql .= ",'" . $quote_user . "'";

			$sql .= ",'" . $quote_type . "'";

			$sql .= ",'" . $quote_date . "'";

			$sql .= ",'" . $quote_time . "'";

			$sql .= ");";



			//	echo "<br>".$sql;		

			mysql_query($sql, $db);
		}
	}
}

//-- save customer data --//

function save_master_data(
$obj1, $obj2, $obj3, $obj4, $obj5, $obj6, $obj7, $obj8, $obj9, $obj10, $obj11, $obj12, $obj13,
 //added on 2020-09-12
		$obj14, //customer_ref_number
		$obj15, //acc_no
		$obj16, //sales_person
		$obj17, //land_phone
		$obj18, //state
		$obj19, //fax
		$obj20, // newslettercheckbox
		$obj21, // here_about_us
		$obj22, //notes
		$obj23, //customer_category
		$obj24, //customer_industry
		$obj25, //customer_status
		$obj26, //po_required_checkbox
		$obj27, //contact_left_checkbox
		$obj28,//account_inactive_checkbox
		$obj29,//address 3
		$obj30//mobile number
)
{

	$db = get_mysql_connection();



	$record_type = $obj8;



	$entry_date = strftime("%Y-%m-%d"); //System Date

	$entry_time = strftime('%H:%M:%S'); //System Time



	if ($record_type == 'c') {



		//-- customer records --//

		$customer_fullname = $obj1;

		$customer_address1 = $obj2;

		$customer_address2 = $obj3;
		
		$customer_address3 = $obj29; // there was a conflict with this field (address3), and again it has has been added after changing it as suburb

		$customer_suburb = $obj4;

		$customer_postcode = $obj5;

		$customer_tel = $obj6;
		
		$customer_mobile = $obj30;

		$customer_email = $obj7;

		$customer_id = $obj10;

		$customer_contactname = $obj12;

		$customer_discount_percentage = $obj13;

		$customer_ref_number = $obj14;

		$acc_no = $obj15;

		$sales_person = $obj16;

		$land_phone = $obj17;

		$state = $obj18;

		$fax = $obj19;

		$newslettercheckbox = $obj20;

		$here_about_us = $obj21;

		$notes = $obj22;

		$customer_category = $obj23;

		$customer_industry = trim($obj24);

		$customer_status = trim($obj25);

		$po_required_checkbox = $obj26 == 'Y' ? 1 : 0;

		$contact_left_checkbox = $obj27 == 'Y' ? 1 : 0;

		$account_inactive_checkbox = $obj28 == 'Y' ? 1 : 0;
		
		$account_status_id = $customer_status ? findStatusByName($customer_status) : 0;
		

		$customer_category_id = $customer_category ? updateCategory($customer_category) : 0;

		$customer_industry_id = $customer_industry ? updateIndustry($customer_industry) : 0;
		//-- if customer id found then update --//

		$sql = "SELECT cuscus_fref FROM customer WHERE cuscus_fref='{$customer_id}'";

		$result = mysql_query($sql);



		$row = mysql_fetch_row($result);

		if (trim($customer_id) == $row[0]) {

			//-- update query --//

			$sql = "UPDATE customer SET

		cusnam='{$customer_fullname}',	

		cusadd1='{$customer_address1}',	

		cusadd2='{$customer_address2}', 
			
		cusadd3='{$customer_address3}', 

		custown='{$customer_suburb}', 

		cuspostcode='{$customer_postcode}',

		custel='{$customer_tel}',
			
		cusmobtel='{$customer_mobile}',

		cusemail='{$customer_email}',

		cuscontact='{$customer_contactname}',

		cusdispcn='{$customer_discount_percentage}',

		cusameddt='{$entry_date}',

		cusametime='{$entry_time}',
		
		cussalesperson='{$sales_person}',
			
		cuslandphone='{$land_phone}',
			
		cusaccno='{$acc_no}',
			
		newslettercheckbox='{$newslettercheckbox}',
			
		here_about_us='{$here_about_us}',
			
		cusfax='{$fax}',
			
		cusstate='{$state}',
			
		notes = '{$notes}',
			
		status_id  = '{$account_status_id}',
			
		po_required = '{$po_required_checkbox}',
			
		contact_left = '{$contact_left_checkbox}',
			
		account_inactive = '{$account_inactive_checkbox}',
			
		categoryId = {$customer_category_id},
			
		industryId = {$customer_industry_id},
			
		cuscontactemail = '{$customer_email}'

		WHERE cuscus_fref='{$customer_id}';";



			//	echo "<br>".$sql;		

			mysql_query($sql, $db);

			//return $sql;

			return true;
		} else {



			$customer_typ = '32';

			$cuscus = next_reference($db, '32');

			$sql = "INSERT INTO customer("
					. "cuscus,"
					. "cusnam,"
					. "cusadd1,"
					. "cusadd2,"
					. "cusadd3,"
					. "custown,"
					. "cuspostcode,"
					. "custel,"
					. "cusmobtel,"
					. "cusemail,"
					. "cuscontact,"
					. "cuscus_fref,"
					. "custypsno,"
					. "cusdispcn,"
					. "cusentddt,"
					. "cusenttime,"
					. "cussalesperson,"
					. "cusaccno,"
					. "cuslandphone,"
					. "newslettercheckbox,"
					. "here_about_us,"
					. "cusfax,"
					. "cusstate,"
					. "po_required,"
					. "contact_left,"
					. "account_inactive,"
					. "notes,"
					. "status_id,"
					. "categoryId,"
					. "industryId,"
					. "cuscontactemail"
					. ") VALUES(";

			$sql .= "'" . $cuscus . "'";

			$sql .= ",'" . $customer_fullname . "'";

			$sql .= ",'" . $customer_address1 . "'";

			$sql .= ",'" . $customer_address2 . "'";
			
			$sql .= ",'" . $customer_address3 . "'";

			$sql .= ",'" . $customer_suburb . "'";

			$sql .= ",'" . $customer_postcode . "'";

			$sql .= ",'" . $customer_tel . "'";
			
			$sql .= ",'" . $customer_mobile . "'";

			$sql .= ",'" . $customer_email . "'";

			$sql .= ",'" . $customer_contactname . "'";

			$sql .= ",'" . $customer_id . "'";

			$sql .= ",'" . $customer_typ . "'";

			$sql .= ",'" . $customer_discount_percentage . "'";

			$sql .= ",'" . $entry_date . "'";

			$sql .= ",'" . $entry_time . "'";

			$sql .= ",'" . $sales_person . "'";

			$sql .= ",'" . $acc_no . "'";

			$sql .= ",'" . $land_phone . "'";

			$sql .= ",'" . $newslettercheckbox . "'";

			$sql .= ",'" . $here_about_us . "'";

			$sql .= ",'" . $fax . "'";

			$sql .= ",'" . $state . "'";

			$sql .= ",'" . $po_required_checkbox . "'";

			$sql .= ",'" . $contact_left_checkbox . "'";

			$sql .= ",'" . $account_inactive_checkbox . "'";

			$sql .= ",'" . $notes . "'";

			$sql .= ",'" . $account_status_id . "'";

			$sql .= ",'" . $customer_category_id . "'";

			$sql .= ",'" . $customer_industry_id . "'";

			$sql .= ",'" . $customer_email . "'";
			$sql .= ");";



			//	echo "<br>".$sql;		

			mysql_query($sql, $db);

			//return $sql;

			return true;
		}
	}
}

//-- save supplier data --//

function save_supplier_master_data(
$obj1, //fullname
		$obj2, //address1
		$obj3, //address2
		$obj4, //address3
		$obj5, //postcode
		$obj6, //telephone
		$obj7, //email
		$obj8, //type
		$obj9, //imagepath
		$obj10, //cusid
		$obj11, //dbid
		$obj12, //contactName		
		$obj13, //clientDiscount
		$obj14, //customer_ref_number
		$obj15, //acc_no
		$obj16, //fax
		$obj17, //supplier_company_name
		$obj18, //supplier_logo
		$obj19, //supplier_desc
		$obj20, //externalproductlink
		$obj21, //supplier_url
		$obj22, //supplier_notes
		$obj23, //rangefeatured
		$obj24, //layouts
		$obj25, //username
		$obj26, //password
		$obj27, //deliverytimes
		$obj28, //freight
		$obj29, //artwork
		$obj30, //samples
		$obj31, //offshore
		$obj32, //sorting
		$obj33, //state
		$obj34, //account_number
		$obj35 //order_email_address
)
{

	$db = get_mysql_connection();

	$record_type = $obj8;

	$entry_date = strftime("%Y-%m-%d"); //System Date
	$entry_time = strftime('%H:%M:%S'); //System Time

	if ($record_type == 's') {

		//-- supplier records --//		

		$supplier_fullname = $obj1;
		$supplier_address1 = $obj2;
		$supplier_address2 = $obj3;
		$supplier_address3 = $obj4;
		$supplier_postcode = $obj5;
		$supplier_state = $obj33;

		$supplier_tel = $obj6;
		$supplier_email = $obj7;
		$supplier_id = $obj10;
		$supplier_imagpath = $obj9;

		$contactName = $obj12;
		$clientDiscount = $obj13;
		$customer_ref_number = $obj14;
		$acc_no = $obj15;
		$fax = $obj16;
		$supplier_company_name = $obj17;
		$supplier_logo = $obj18;
		$supplier_desc = $obj19;
		$externalproductlink = $obj20;
		$supplier_url = $obj21;
		$supplier_notes = $obj22;
		$rangefeatured = $obj23;
		$layouts = $obj24;
		$username = $obj25;
		$password = $obj26;
		$deliverytimes = $obj27;
		$freight = $obj28;
		$artwork = $obj29;
		$samples = $obj30;
		$offshore = $obj31;
		$sorting = $obj32;

		$supplier_account_number = $obj34;
		$order_email_address = $obj35;


		//-- if customer id found then update --//

		$sql = "SELECT supsup_fref FROM supplier WHERE supsup_fref='{$supplier_id}'";
		$result = mysql_query($sql);

		$row = mysql_fetch_row($result);

		if (trim($supplier_id) == $row[0]) {

			//-- update query --//

			$sql = "UPDATE supplier SET
		supnam='{$supplier_fullname}',
		supad1='{$supplier_address1}',
		supad2='{$supplier_address2}', 
		supad3='{$supplier_address3}',
		suppostcode='{$supplier_postcode}',
		suptel='{$supplier_tel}',
		supemail='{$supplier_email}',
		supimgpath='{$supplier_imagpath}',
		supcontact='{$contactName}', 	
		
		clientDiscount='{$clientDiscount}', 
		customer_ref_number='{$customer_ref_number}',
		supfax='{$fax}',
		supplier_company_name='{$supplier_company_name}',
		supplier_logo='{$supplier_logo}',
		supplier_desc='{$supplier_desc}',
		external_product_link='{$externalproductlink}',
		supplier_url='{$supplier_url}',
		supplier_notes='{$supplier_notes}',
		rangefeatured='{$rangefeatured}',
		layouts='{$layouts}',	
		username='{$username}',	
		password='{$password}',
		deliverytimes='{$deliverytimes}',
		freight_desc='{$freight}',
		artwork='{$artwork}',
		samples='{$samples}',
		offshore='{$offshore}',
		sorting='{$sorting}',	
			
		supstate='{$supplier_state}',
		acc_no='{$supplier_account_number}',
		order_email='{$order_email_address}',
		
			
		supameddt='{$entry_date}',
		supametime='{$entry_time}'
		WHERE supsup_fref='{$supplier_id}';";

			//	echo "<br>".$sql;		

			mysql_query($sql, $db);
			//return $sql;
			return true;
		} else {


			$supplier_typ = '31';

			$supsup = next_reference($db, '31');

			$sql = "INSERT INTO supplier("
					. "supsup,"
					. "supnam,"
					. "supad1,"
					. "supad2,"
					. "supad3,"
					. "suppostcode,"
					. "suptel,"
					. "supemail,"
					. "supsup_fref,"
					. "suptypsno,"
					. "supimgpath,"
					. "supcontact,"
					. "clientDiscount,"
					. "customer_ref_number,"
					. "supfax,"
					. "supplier_company_name,"
					. "supplier_logo,"
					. "supplier_desc,"
					. "external_product_link,"
					. "supplier_url,"
					. "supplier_notes,"
					. "rangefeatured,"
					. "layouts,"
					. "username,"
					. "password,"
					. "deliverytimes,"
					. "freight_desc,"
					. "artwork,"
					. "samples,"
					. "offshore,"
					. "sorting,"
					. "supstate,"
					. "acc_no,"
					. "order_email,"
					. "supentddt,"
					. "supenttime"
					. ") VALUES(";

			$sql .= "'" . $supsup . "'";
			$sql .= ",'" . $supplier_fullname . "'";
			$sql .= ",'" . $supplier_address1 . "'";
			$sql .= ",'" . $supplier_address2 . "'";
			$sql .= ",'" . $supplier_address3 . "'";
			$sql .= ",'" . $supplier_postcode . "'";
			$sql .= ",'" . $supplier_tel . "'";
			$sql .= ",'" . $supplier_email . "'";
			$sql .= ",'" . $supplier_id . "'";
			$sql .= ",'" . $supplier_typ . "'";
			$sql .= ",'" . $supplier_imagpath . "'";

			$sql .= ",'" . $contactName . "'";
			$sql .= ",'" . $clientDiscount . "'";
			$sql .= ",'" . $customer_ref_number . "'";
			$sql .= ",'" . $fax . "'";
			$sql .= ",'" . $supplier_company_name . "'";
			$sql .= ",'" . $supplier_logo . "'";
			$sql .= ",'" . $supplier_desc . "'";
			$sql .= ",'" . $externalproductlink . "'";
			$sql .= ",'" . $supplier_url . "'";
			$sql .= ",'" . $supplier_notes . "'";
			$sql .= ",'" . $rangefeatured . "'";
			$sql .= ",'" . $layouts . "'";
			$sql .= ",'" . $username . "'";
			$sql .= ",'" . $password . "'";
			$sql .= ",'" . $deliverytimes . "'";
			$sql .= ",'" . $freight . "'";

			$sql .= ",'" . $artwork . "'";
			$sql .= ",'" . $samples . "'";
			$sql .= ",'" . $offshore . "'";
			$sql .= ",'" . $sorting . "'";

			$sql .= ",'" . $supplier_state . "'";
			$sql .= ",'" . $supplier_account_number . "'";
			$sql .= ",'" . $order_email_address . "'";


			$sql .= ",'" . $entry_date . "'";
			$sql .= ",'" . $entry_time . "'";
			$sql .= ");";

			//	echo "<br>".$sql;		

			mysql_query($sql, $db);

			//return $sql;

			return true;
		}
	}
}

function next_reference($db, $v_typsno)
{

	if ($v_typsno == '31') {

		$v_typdes = "S";

		$sql_ref = "select supsup from supplier order by supsup desc  limit 1";
	}

	if ($v_typsno == '32') {

		$v_typdes = "C";

		$sql_ref = "select cuscus supsup from customer order by cuscus desc limit 1";
	}

	$result_ref = mysql_query($sql_ref, $db) or die("SQL Error sql_ref <br />" . mysql_error());

	if (mysql_num_rows($result_ref)) {

		$fields_ref = mysql_fetch_array($result_ref, MYSQL_BOTH);

		$v_supsup = substr($fields_ref['supsup'], 1, 4);

		$v_supsup += 1;

		mysql_free_result($result_ref);
	} else {

		$v_supsup = 1;
	}



	$v_supsup = str_pad($v_supsup, 4, 0, STR_PAD_LEFT);

	$v_supsup = $v_typdes . $v_supsup;



	return $v_supsup;
}

/**
 * This will  check if record is available then update the record otherwise it will create new record
 * @return int id existing record or newly created record id
 * @param string $categoryName 
 */
function updateCategory($categoryName)
{
	$connection = get_mysqli_connection();
	$sql = "SELECT id FROM customer_category WHERE name='{$categoryName}';";

	$result = mysqli_query($connection, $sql);

	if (!$row = mysqli_fetch_row($result)) {
		$sql = "INSERT INTO customer_category (name) VALUES ('{$categoryName}');";
		if (mysqli_query($connection, $sql)) {
			return mysqli_insert_id($connection);
		}
	} else {
		return $row[0];
	}

	return 0;
}

/**
 * This will  check if record is available then update the record otherwise it will create new record
 * @return void
 * @param string $industryName 
 */
function updateIndustry($industryName)
{
	$connection = get_mysqli_connection();
	$sql = "SELECT id FROM customer_industry WHERE name='{$industryName}';";

	$result = mysqli_query($connection, $sql);

	if (!$row = mysqli_fetch_row($result)) {
		$sql = "INSERT INTO customer_industry (name) VALUES ('{$industryName}');";
		if (mysqli_query($connection, $sql)) {
			return mysqli_insert_id($connection);
		}
	} else {
		return $row[0];
	}

	return 0;
}

/**
 * TThis will  check if record is available and return the id
 * @return int id 
 * @param string $statusName 
 */
function findStatusByName($statusName)
{
	$connection = get_mysqli_connection();
	$sql = "SELECT id FROM status WHERE name='{$statusName}';";

	$result = mysqli_query($connection, $sql);

	if ($row = mysqli_fetch_row($result)) {		
		return $row[0];
	}

	return null;
}

?>